% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeakRank.R
\name{WeakRank}
\alias{WeakRank}
\title{Weak ranking family}
\usage{
WeakRank(K)
}
\arguments{
\item{K}{Indicates that we are only interesting in the top \eqn{K} instances. Must be an integer between 1
and the number \eqn{n} of observations.}
}
\value{
A Boosting family object
}
\description{
{Gradient-free Gradient Boosting family for the weak ranking loss function.}
}
\details{
{The weak ranking loss may be regarded as a classification loss. The parameter \code{K} defines the top of the list,
consisting of the best \eqn{K} instances according to their response values. Then the weak ranking loss penalizes
''misclassification'' in the sense that instances belonging to the top of the list are ranked lower and vice versa.
\code{WeakRank} returns a family object as in the package \code{mboost}.}
}
\examples{
{y<-c(-3, 10.3,-8, 12, 14,-0.5, 29,-1.1,-5.7, 119)
yhat<-c(0.02, 0.6, 0.1, 0.47, 0.82, 0.04, 0.77, 0.09, 0.01, 0.79)
WeakRank(4)@risk(y,yhat)}
{y<-c(-3, 10.3,-8, 12, 14,-0.5, 29,-1.1,-5.7, 119)
yhat<-c(0.02, 0.6, 0.1, 0.47, 0.82, 0.04, 0.77, 0.09, 0.01, 0.79)
WeakRank(5)@risk(y,yhat)}
}
\references{
{Werner, T., Gradient-Free Gradient Boosting, PhD Thesis, Carl von Ossietzky University Oldenburg, 2020,
Remark (5.2.1)}

{T. Hothorn, P. Bühlmann, T. Kneib, M. Schmid, and B. Hofner. mboost: Model-Based
Boosting, 2017}
}
