% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residuals.R
\name{plot_residuals}
\alias{plot_residuals}
\title{Plot Residuals from 'isatpanel' against OLS}
\usage{
plot_residuals(isatpanelobject)
}
\arguments{
\item{isatpanelobject}{An output from the 'isatpanel' function}
}
\value{
A ggplot2 plot that plots an 'isatpanel' object and shows the residuals over time in comparison to an OLS model.
}
\description{
Plot Residuals from 'isatpanel' against OLS
}
\examples{
\donttest{
data(EU_emissions_road)

# Group specification
EU15 <- c("Austria", "Germany", "Denmark", "Spain", "Finland", "Belgium",
         "France", "United Kingdom", "Ireland", "Italy", "Luxembourg",
         "Netherlands", "Greece", "Portugal", "Sweden")

# Prepare sample and data
EU_emissions_road_short <- EU_emissions_road[
EU_emissions_road$country \%in\% EU15 &
EU_emissions_road$year >= 2000,
]

# Run
result <- isatpanel(
  data = EU_emissions_road_short,
  formula = ltransport.emissions ~ lgdp + I(lgdp^2) + lpop,
  index = c("country", "year"),
  effect = "twoways",
  fesis = TRUE,
  plot = FALSE,
  t.pval = 0.01
)
plot(result)
plot_residuals(result)
}
}
