\name{gesca.rick2}
\alias{gesca.rick2}
\docType{data}
\title{
Bagozzi's organizational identification example
}
\description{
This example is part of the organizational identification data used in Bergami and Bagozzi (2000). The data are used in Hwang and Takane (2014) (see Chapter 3). The data contain a sample of 305 employees (male = 157 and female = 148) and 22 indicators.
}
\usage{data(gesca.rick2)}
\format{
  A data frame with 305 observations on the following 22 variables.
  \describe{
    \item{\code{gender}}{grouping variable - gender (1 = male, 2 = female)}
    \item{\code{cei1}}{First indicator associated with the first latent variable - Organizational Prestige}
    \item{\code{cei2}}{Second indicator associated with the first latent variable - Organizational Prestige}
    \item{\code{cei3}}{Third indicator associated with the first latent variable - Organizational Prestige}
    \item{\code{cei4}}{Fourth indicator associated with the first latent variable - Organizational Prestige}
    \item{\code{cei5}}{Fifth indicator associated with the first latent variable - Organizational Prestige}
    \item{\code{cei6}}{Sixth indicator associated with the first latent variable - Organizational Prestige}
    \item{\code{cei7}}{Seventh indicator associated with the first latent variable - Organizational Prestige}
    \item{\code{cei8}}{Eighth indicator associated with the first latent variable - Organizational Prestige}
    \item{\code{ma1}}{First indicator associated with the second latent variable - Organizational Identification}
    \item{\code{ma2}}{Second indicator associated with the second latent variable - Organizational Identification}
    \item{\code{ma3}}{Third indicator associated with the second latent variable - Organizational Identification}
    \item{\code{ma4}}{Fourth indicator associated with the second latent variable - Organizational Identification}
    \item{\code{ma5}}{Fifth indicator associated with the second latent variable - Organizational Identification}
    \item{\code{ma6}}{Sixth indicator associated with the second latent variable - Organizational Identification}
    \item{\code{orgcmt1}}{First indicator associated with the third latent variable - Affective Commitment-Joy}
    \item{\code{orgcmt2}}{Second indicator associated with the third latent variable - Affective Commitment-Joy}
    \item{\code{orgcmt3}}{Third indicator associated with the third latent variable - Affective Commitment-Joy}
    \item{\code{orgcmt7}}{Fourth indicator associated with the third latent variable - Affective Commitment-Joy}
    \item{\code{orgcmt5}}{First indicator associated with the fourth latent variable - Affective Commitment-Love}
    \item{\code{orgcmt6}}{Second indicator associated with the fourth latent variable - Affective Commitment-Love}
    \item{\code{orgcmt8}}{Third indicator associated with the fourth latent variable - Affective Commitment-Love}
  }
}
\references{
Bergami, M., & Bagozzi, R. P. (2000). Self-categorization, affective commitment and group self-esteem as distinct aspects of social identity in the organization. \emph{British Journal of Social Psychology}, \emph{39}(4), 555-577.


Hwang, H., & Takane, Y. (2014). Generalized Structured Component Analysis: A Component-Based Approach to Structural Equation Modeling (pp.112-119). Boca Raton, FL: Chapman & Hall/CRC Press.
}
\examples{
data(gesca.rick2)
str(gesca.rick2)
}
\keyword{datasets}
