% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeightGermPercent.R
\name{WeightGermPercent}
\alias{WeightGermPercent}
\title{Weighted germination percentage}
\usage{
WeightGermPercent(germ.counts, total.seeds, intervals, partial = TRUE)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{total.seeds}{Total number of seeds tested.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
The weighted germination percentage (\%) value.
}
\description{
Compute the Weighted germination percentage
\ifelse{html}{\out{<i>WGP</i>}}{\eqn{WGP}} or Weighted germination index
\ifelse{html}{\out{<i>WGI</i>}}{\eqn{WGI}}
\insertCite{reddy_effect_1978,reddy_effect_1985}{germinationmetrics}.
}
\details{
Weighted germination percentage was calculated by giving maximum weight to
the seeds that germinate first and decreasing weight to the seeds that
germinate subsequently. It is computed as follows
\insertCite{reddy_effect_1978,reddy_effect_1985}{germinationmetrics}:

\ifelse{html}{\out{<p style="text-align: center;"><em>WGP =   <big>[</big>
<sup> [&sum;<sup>t</sup><sub style="line-height: 1.8; margin-left:
-1ex;">i=1</sub> (t &minus; i + 1)N<sub>i</sub>]</sup> &frasl; <sub>t &times;
N</sub> <big>]</big> &times; 100 </em></p>}}{\deqn{WGP =
\frac{\sum_{i=1}^{t}(t-i+1)N_{i}}{t \times N} \times 100}}

Where, \ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}}  is the  number
of seeds that germinated in the time interval
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}} (not cumulative, but partial count),
\ifelse{html}{\out{<i>N</i>}}{\eqn{N}} is the total number of seeds tested
and \ifelse{html}{\out{<i>t</i>}}{\eqn{t}} is the  total number of time
intervals.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
WeightGermPercent(germ.counts = x, total.seeds = 50, intervals = int)

# From cumulative germination counts
#----------------------------------------------------------------------------
WeightGermPercent(germ.counts = y, total.seeds = 50, intervals = int,
                  partial = FALSE)


}
\references{
\insertAllCited{}
}
