% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeanGermRate.R
\name{MeanGermRate}
\alias{MeanGermRate}
\alias{CVG}
\alias{VarGermRate}
\alias{SEGermRate}
\alias{GermRateRecip}
\title{Germination rate}
\usage{
MeanGermRate(germ.counts, intervals, partial = TRUE)

CVG(germ.counts, intervals, partial = TRUE)

VarGermRate(germ.counts, intervals, partial = TRUE)

SEGermRate(germ.counts, intervals, partial = TRUE)

GermRateRecip(germ.counts, intervals, partial = TRUE,
  method = c("coolbear", "farooq"))
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}

\item{method}{The method for computing median germination time. Either
\code{"coolbear"} or \code{"farooq"}.}
}
\value{
For \code{MeanGermRate}, the mean germination rate value as
  \ifelse{html}{\out{time<sup>-1</sup>}}{\eqn{\mathrm{time^{-1}}}}.

  For \code{VarGermTime}, the variance of germination rate value as
  \ifelse{html}{\out{time<sup>-2</sup>}}{\eqn{\mathrm{time^{-2}}}}.

  For \code{SEGermTime}, the standard error of germination rate as
  \ifelse{html}{\out{time<sup>-1</sup>}}{\eqn{\mathrm{time^{-1}}}}.

  For \code{CVG}, the value of Coefficient of of velocity/rate of germination
  or Kotowski's coefficient of velocity.

  For \code{GermRateRecip}, the value of germination rate as
  \ifelse{html}{\out{time<sup>-1</sup>}}{\eqn{\mathrm{time^{-1}}}}.
}
\description{
Compute the following metrics: \describe{ \item{\code{MeanGermRate}}{Mean
germination rate (\ifelse{html}{\out{<em><span
style="text-decoration:overline">V</span></em>}}{\eqn{\overline{V}}})
\insertCite{labouriau_germination_1976,labouriau_uma_1983,ranal_how_2006}{germinationmetrics}.}
\item{\code{VarGermRate}}{Variance of germination rate
(\ifelse{html}{\out{<em>s<sup>2</sup><sub style="line-height: 1.8;
margin-left: -1ex;">V</sub></em>}}{\eqn{s_{V}^{2}}})
\insertCite{labouriau_uma_1983,ranal_how_2006}{germinationmetrics}. }
\item{\code{SEGermRate}}{Standard error of germination rate
(\ifelse{html}{\out{<em>s<sub><span
style="text-decoration:overline">V</span></sub></em>}}{\eqn{s_{\overline{V}}}})
\insertCite{labouriau_uma_1983,ranal_how_2006}{germinationmetrics}. }
\item{\code{CVG}}{Coefficient of velocity/rate of germination or Kotowski's
coefficient of velocity
(\ifelse{html}{\out{<i>CVG</i>}}{\ifelse{html}{\out{<i>CVG</i>}}{\eqn{CVG}}})
\insertCite{kotowski_temperature_1926,nichols_two_1968,labouriau_uma_1983,scott_review_1984,bewley_seeds:_1994}{germinationmetrics}.
} \item{\code{GermRateRecip}}{Germination rate as reciprocal of median time
(\ifelse{html}{\out{<i>v<sub>50</sub></i>}}{\eqn{v_{50}}})
\insertCite{went_experimental_1957,labouriau_uma_1983,ranal_how_2006}{germinationmetrics}.}
}
}
\details{
\code{MeanGermRate} computes the mean germination rate
(\ifelse{html}{\out{<em><span
style="text-decoration:overline">V</span></em>}}{\eqn{\overline{V}}})
according to the following formula
\insertCite{labouriau_germination_1976,labouriau_uma_1983,ranal_how_2006}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em><span
style="text-decoration: overline;">V</span> = <sup>&sum;<sup>k</sup><sub
style="line-height: 1.8; margin-left: -1ex;">i=1</sub> N<sub>i</sub></sup>
&frasl; <sub>&sum;<sup>k</sup><sub style="line-height: 1.8; margin-left:
-1ex;">i=1</sub>
N<sub>i</sub>T<sub>i</sub></sub></em></p>}}{\deqn{\overline{V} =
\frac{\sum_{i=1}^{k}N_{i}}{\sum_{i=1}^{k}N_{i}T_{i}}}}

Where, \ifelse{html}{\out{<i>T<sub>i</sub></i>}}{\eqn{T_{i}}} is the time
from the start of the experiment to the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation,
\ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}} is the number of seeds
germinated in the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time (not the
accumulated number, but the number correspondent to the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation) and
\ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is the last time of germination.

It is the inverse of mean germination time (\ifelse{html}{\out{<em><span
style="text-decoration:overline">T</span></em>}}{\eqn{\overline{T}}}).

\ifelse{html}{\out{<p style="text-align: center;"><em><span
style="text-decoration: overline;">V</span> = <sup>1</sup> &frasl; <sub><span
style="text-decoration:
overline;">T</span></sub></em></p>}}{\deqn{\overline{V} =
\frac{1}{\overline{T}}}}

\code{VarGermRate} computes the variance of germination rate
(\ifelse{html}{\out{<em>s<sup>2</sup><sub style="line-height: 1.8;
margin-left: -1ex;">V</sub></em>}}{\eqn{s_{V}^{2}}}) according to the
following formula
\insertCite{labouriau_uma_1983,ranal_how_2006}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em>s<sup>2</sup><sub
style="line-height: 1.8; margin-left: -1ex;">V</sub> = <span
style="text-decoration: overline;">V</span><sup>4</sup> &times;
s<sup>2</sup><sub style="line-height: 1.8; margin-left:
-1ex;">T</sub></em></p>}}{\deqn{s_{V}^{2} = \overline{V}^{4} \times
s_{T}^{2}}}

Where, \ifelse{html}{\out{<em>s<sup>2</sup><sub style="line-height: 1.8;
margin-left: -1ex;">T</sub></em>}}{\eqn{s_{T}^{2}}} is the variance of
germination time.

\code{SEGermRate} computes the standard error of germination time
(\ifelse{html}{\out{<em>s<sub><span
style="text-decoration:overline">V</span></sub></em>}}{\eqn{s_{\overline{V}}}})
according to the following formula
\insertCite{labouriau_uma_1983,ranal_how_2006}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em>s<sub><span
style="text-decoration: overline;">V</span></sub> = &radic;[
<sup>s<sup>2</sup><sub style="line-height: 1.8; margin-left:
-1ex;">V</sub></sup> &frasl; <sub>&sum;<sup>k</sup><sub style="line-height:
1.8; margin-left: -1ex;">i=1</sub> N<sub>i</sub></sub>
]</em></p>}}{\deqn{s_{\overline{V}} =
\sqrt{\frac{s_{V}^{2}}{\sum_{i=1}^{k}N_{i}}}}}

Where, \ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}} is the number
of seeds germinated in the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time (not
the accumulated number, but the number correspondent to the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation) and
\ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is the last time of germination.

\code{CVG} computes the coefficient of velocity/rate of germination or
Kotowski's coefficient of velocity
(\ifelse{html}{\out{<i>CVG</i>}}{\eqn{CVG}}) according to the following
formula
\insertCite{kotowski_temperature_1926,nichols_two_1968,labouriau_uma_1983,scott_review_1984,bewley_seeds:_1994}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em>CVG =
[<sup>&sum;<sup>k</sup><sub style="line-height: 1.8; margin-left:
-1ex;">i=1</sub> N<sub>i</sub></sup> &frasl; <sub>&sum;<sup>k</sup><sub
style="line-height: 1.8; margin-left: -1ex;">i=1</sub>
N<sub>i</sub>T<sub>i</sub></sub>] &times; 100</em></p>}}{\deqn{CVG =
\frac{\sum_{i=1}^{k}N_{i}}{\sum_{i=1}^{k}N_{i}T_{i}} \times 100}}

\ifelse{html}{\out{<p style="text-align: center;"><em>CVG = <span
style="text-decoration: overline;">V</span> &times; 100</em></p>}}{\deqn{CVG
= \overline{V} \times 100}}

Where, \ifelse{html}{\out{<i>T<sub>i</sub></i>}}{\eqn{T_{i}}} is the time
from the start of the experiment to the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation,
\ifelse{html}{\out{<i>N<sub>i</sub></i>}}{\eqn{N_{i}}} is the number of seeds
germinated in the \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th time (not the
accumulated number, but the number correspondent to the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th observation) and
\ifelse{html}{\out{<i>k</i>}}{\eqn{k}} is the last time of germination.

\code{GermRateRecip} computes the germination rate
(\ifelse{html}{\out{<em>v<sub>50</sub></em>}}{\eqn{v_{50}}}) as the
reciprocal of the median germination time
(\ifelse{html}{\out{<em>t<sub>50</sub></em>}}{\eqn{t_{50}}})
\insertCite{went_experimental_1957,labouriau_uma_1983,ranal_how_2006}{germinationmetrics}
computed according to the methods of
\insertCite{coolbear_effect_1984;textual}{germinationmetrics} or
\insertCite{farooq_thermal_2005;textual}{germinationmetrics} as follows:

\ifelse{html}{\out{<p style="text-align: center;"><em>v<sub>50</sub> =
<sup>1</sup> &frasl;
<sub><em>t<sub>50</sub></em></sub></em></p>}}{\deqn{v_{50} =
\frac{1}{t_{50}}}}
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
MeanGermRate(germ.counts = x, intervals = int)
CVG(germ.counts = x, intervals = int)
VarGermRate(germ.counts = x, intervals = int)
SEGermRate(germ.counts = x, intervals = int)
GermRateRecip(germ.counts = x, intervals = int, method = "coolbear")
GermRateRecip(germ.counts = x, intervals = int, method = "farooq")

# From cumulative germination counts
#----------------------------------------------------------------------------
MeanGermRate(germ.counts = y, intervals = int, partial = FALSE)
CVG(germ.counts = y, intervals = int, partial = FALSE)
VarGermRate(germ.counts = y, intervals = int, partial = FALSE)
SEGermRate(germ.counts = y, intervals = int, partial = FALSE)
GermRateRecip(germ.counts = y, intervals = int,
              method = "coolbear", partial = FALSE)
GermRateRecip(germ.counts = y, intervals = int,
              method = "farooq", partial = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[germinationmetrics]{MeanGermTime}},
  \code{\link[germinationmetrics]{t50}}
}
