% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_uy.R
\name{which_uy}
\alias{which_uy}
\title{This function allows to add to an 'sf' object its spatial coincidence with one or more administrative units in Uruguay, generating the corresponding variables.}
\usage{
which_uy(x, c = c("Localidades pg", "Departamentos"), d = c("cod", "name"))
}
\arguments{
\item{x}{An 'sf' object with the same crs as the homonym parameter}

\item{c}{Define the geometries to download: may be: "Departamentos", "Secciones", "Zonas", etc. View(metadata) for details.}

\item{d}{A vector who determines the variables to be added, with three options: "cod", "name", or "full". Default c("cod", "name").}
}
\value{
sf object with the x geometries, with d variables requested from c added
}
\description{
This function allows to add to an 'sf' object its spatial coincidence with one or more administrative units in Uruguay, generating the corresponding variables.
}
\examples{
\donttest{
x <- load_geouy("Peajes")
x1 <- which_uy(x, c = "Deptos")
}
}
\seealso{
Other service: 
\code{\link{add_geom}()},
\code{\link{geocode_ide_uy}()},
\code{\link{load_geouy}()},
\code{\link{reverse_ide_uy}()},
\code{\link{tiles_geouy}()},
\code{\link{where_uy}()}
}
\concept{service}
\keyword{IDE}
\keyword{INE}
\keyword{MIDES}
