% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gboot_solow.R
\name{gboot_solow}
\alias{gboot_solow}
\title{Solow bootstrap}
\usage{
gboot_solow(data,var,model,B)
}
\arguments{
\item{data}{object of the class geodata.}

\item{var}{object of the class variogram.}

\item{model}{object of the class variomodel.}

\item{B}{number of the bootstrap that will be performed (default B=1000).}
}
\value{
\bold{variogram_boot} gives the variogram of each bootstrap.

\bold{variogram_or} gives the original variogram.

\bold{pars_boot} gives the estimatives of the nugget, sill, contribution, range and practical range for each bootstrap.

\bold{pars_or} gives the original estimatives of the nugget, sill, contribution, range and practical range.

Invalid arguments will return an error message.
}
\description{
Performs a spatial boostrap proposed by Solow(1985).
}
\details{
The basic idea involves transforming correlated observation to uncorrelated
quantities, forming a bootstrap sample from these quantities, and transforming back to a
bootstrap sample form the original observations (SOLOW, 1985). Suppose that \eqn{Z_n}
is an \eqn{n} vector of observations from a realization of a second-order stationary
random process, \eqn{Z(s_i)}, and the covariance matrix for \eqn{Z_n} is \eqn{C}. Suppose
further that \eqn{E(Z_n)={0_n}}, where \eqn{{0_n}} is an \eqn{n} vector of zeroes.
In practice \eqn{Z_n} can be centered by subtracting an estimate of the stationary mean from
each observation. So, the steps of the algorithm are:

\enumerate{
\item Obtain \eqn{C};
\item Apply the Cholesky decomposition in \eqn{C}, obtaining \eqn{C=LL^t}, where
\eqn{L} is lower triangular;
\item Obtain \eqn{U_n=L^{-1}Z_n};
\item Sample with replacement \eqn{{U^*}_n} from \eqn{U_n - \bar U_n};
\item The new data will be \eqn{{Z^*}_n=L{U^*}_n};
\item Calculate the new variogram;
\item Calculate and save the statistics of interest;
\item Return to step 4 and repeat the process at least 1000 times.
}
}
\examples{
# Example 1

## transforming the data.frame in an object of class geodata
data<- as.geodata(soilmoisture)

points(data) ## data visualization

var<- variog(data, max.dist = 140) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(2,80),nugget = 2,cov.model = "sph")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_solow(data,var,mod,B=10)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot

\dontrun{
# Example 2

## transforming the data.frame in an object of class geodata
data<- as.geodata(NVDI)

points(data) ## data visualization

var<- variog(data, max.dist = 18) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(0.003,6),nugget = 0.003,cov.model = "gaus")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_solow(data,var,mod,B=10)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot
}
}
\references{
Solow, A. R. (1985). Bootstrapping correlated data. Journal of the International Association for Mathematical Geology, 17(7), 769-775. https://doi.org/10.1007/BF01031616
}
\author{
Diogo Francisco Rossoni \email{dfrossoni@uem.br}

Vinicius Basseto Felix \email{felix_prot@hotmail.com}
}
\keyword{Bootstrap}
\keyword{Solow}
\keyword{Spatial}
