% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSLayer.R, R/GSStyle.R
\docType{class}
\name{GSLayer}
\alias{GSLayer}
\alias{GSStyle}
\title{A GeoServer layer resource}
\format{
\code{\link{R6Class}} object.

\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer layer

Object of \code{\link{R6Class}} for modelling a GeoServer style
}
\description{
This class models a GeoServer layer. This class is to be
used for published resource (feature type or coverage).

This class models a GeoServer style.
}
\details{
Geoserver REST API Resource

Geoserver REST API Style
}
\examples{
  lyr <- GSLayer$new()

  lyr <- GSStyle$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{coverage}
\keyword{featureType}
\keyword{geoserver}
\keyword{layer}
\keyword{resource}
\keyword{resourcelayer}
\keyword{rest}
\keyword{style}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSLayer}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{full}}{full}

\item{\code{name}}{name}

\item{\code{path}}{path}

\item{\code{defaultStyle}}{default style}

\item{\code{styles}}{styles}

\item{\code{enabled}}{enabled}

\item{\code{queryable}}{queryable}

\item{\code{advertised}}{advertised}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSLayer-new}{\code{GSLayer$new()}}
\item \href{#method-GSLayer-decode}{\code{GSLayer$decode()}}
\item \href{#method-GSLayer-setName}{\code{GSLayer$setName()}}
\item \href{#method-GSLayer-setPath}{\code{GSLayer$setPath()}}
\item \href{#method-GSLayer-setEnabled}{\code{GSLayer$setEnabled()}}
\item \href{#method-GSLayer-setQueryable}{\code{GSLayer$setQueryable()}}
\item \href{#method-GSLayer-setAdvertised}{\code{GSLayer$setAdvertised()}}
\item \href{#method-GSLayer-setDefaultStyle}{\code{GSLayer$setDefaultStyle()}}
\item \href{#method-GSLayer-setStyles}{\code{GSLayer$setStyles()}}
\item \href{#method-GSLayer-addStyle}{\code{GSLayer$addStyle()}}
\item \href{#method-GSLayer-delStyle}{\code{GSLayer$delStyle()}}
\item \href{#method-GSLayer-clone}{\code{GSLayer$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GSLayer}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-setName"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-setName}{}}}
\subsection{Method \code{setName()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-setPath"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-setPath}{}}}
\subsection{Method \code{setPath()}}{
Set path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-setEnabled"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-setEnabled}{}}}
\subsection{Method \code{setEnabled()}}{
Set enabled
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setEnabled(enabled)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{enabled}}{enabled}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-setQueryable"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-setQueryable}{}}}
\subsection{Method \code{setQueryable()}}{
Set queryable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setQueryable(queryable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{queryable}}{queryable}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-setAdvertised"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-setAdvertised}{}}}
\subsection{Method \code{setAdvertised()}}{
Set advertised
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setAdvertised(advertised)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{advertised}}{advertised}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-setDefaultStyle"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-setDefaultStyle}{}}}
\subsection{Method \code{setDefaultStyle()}}{
Set default style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setDefaultStyle(style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{object o class \link{GSStyle} or \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-setStyles"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-setStyles}{}}}
\subsection{Method \code{setStyles()}}{
Set styles
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$setStyles(styles)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styles}}{styles}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-addStyle"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-addStyle}{}}}
\subsection{Method \code{addStyle()}}{
Adds style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$addStyle(style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{style, object o class \link{GSStyle} or \code{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-delStyle"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-delStyle}{}}}
\subsection{Method \code{delStyle()}}{
Deletes style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$delStyle(style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{style, object o class \link{GSStyle} or \code{character}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSStyle}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{full}}{full}

\item{\code{name}}{name}

\item{\code{filename}}{filename}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSStyle-new}{\code{GSStyle$new()}}
\item \href{#method-GSStyle-decode}{\code{GSStyle$decode()}}
\item \href{#method-GSStyle-setName}{\code{GSStyle$setName()}}
\item \href{#method-GSStyle-setFilename}{\code{GSStyle$setFilename()}}
\item \href{#method-GSStyle-clone}{\code{GSStyle$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyle-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyle-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{GSStyle}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$new(xml = NULL, name = NULL, filename = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link{XMLInternalNode-class}}

\item{\code{name}}{name}

\item{\code{filename}}{filename}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyle-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyle-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyle-setName"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyle-setName}{}}}
\subsection{Method \code{setName()}}{
set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyle-setFilename"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyle-setFilename}{}}}
\subsection{Method \code{setFilename()}}{
Set filename
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$setFilename(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{filename}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSStyle-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSStyle-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSStyle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
