% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_polygon.R
\name{gs_polygon}
\alias{gs_polygon}
\alias{gs_triangle}
\alias{gs_square}
\alias{gs_rectangle}
\alias{gs_hexagon}
\title{Create a polygon \code{geom}}
\usage{
gs_polygon(
  anchor = NULL,
  window = NULL,
  features = 1,
  vertices = 3,
  regular = FALSE,
  ...
)

gs_triangle(anchor = NULL, window = NULL, features = 1, ...)

gs_square(anchor = NULL, window = NULL, features = 1, ...)

gs_rectangle(anchor = NULL, window = NULL, features = 1, ...)

gs_hexagon(anchor = NULL, window = NULL, features = 1, ...)
}
\arguments{
\item{anchor}{[\code{geom(1)}|\code{data.frame(1)}]\cr Object to derive the
\code{geom} from. It must include column names \code{x}, \code{y} and
optionally a custom \code{fid}.}

\item{window}{[\code{data.frame(1)}]\cr in case the reference window deviates
from the bounding box of \code{anchor} (minimum and maximum values),
specify this here.}

\item{features}{[\code{integerish(1)}]\cr number of polygons to create.}

\item{vertices}{[\code{integerish(.)}]\cr number of vertices per polygon;
will be recycled if it does not have as many elements as specified in
\code{features}.}

\item{regular}{[\code{logical(1)}]\cr should the polygon be regular, i.e.
point symmetric (\code{TRUE}) or should the vertices be selected as
provided by \code{anchor} (\code{FALSE}, default)?}

\item{...}{[various]\cr graphical parameters to \code{\link{gt_locate}}, in
case points are sketched; see \code{\link[grid]{gpar}}}
}
\value{
A \code{geom}.
}
\description{
Create any (regular) polygon geometry (of class \code{\link{geom}}) either by
specifying anchor values or by sketching it.
}
\details{
The argument \code{anchor} indicates how the geom is created:
  \itemize{ \item if \code{anchor} is set, the geom is created parametrically
  from the points given in \code{anchor}, \item if it is not set either
  \code{window} or a default window between 0 and 1 is opened to sketch the
  geom.}

  The argument \code{regular} determines how the vertices provided in
  \code{anchor} or via \code{template} are transformed into a polygon:
  \itemize{ \item if \code{regular = FALSE} the resulting polygon is created
  from all vertices in \code{anchor}, \item if \code{regular = TRUE}, only
  the first two vertices are considered, as center and indicating the
  distance to the (outer) radius.}
}
\section{Functions}{
\itemize{
\item \code{gs_triangle}: wrapper of gs_polygon where \code{vertices = 3} and
\code{regular = TRUE}.

\item \code{gs_square}: wrapper of gs_polygon where \code{vertices = 4} and
\code{regular = TRUE}.

\item \code{gs_rectangle}: wrapper of gs_polygon where \code{vertices = 2},
\code{regular = FALSE} and the two complementing corners are derived from
the two given opposing corners.

\item \code{gs_hexagon}: wrapper of gs_polygon where \code{vertices = 6} and
\code{regular = TRUE}.
}}

\examples{
# 1. create a polygon programmatically
coords <- data.frame(x = c(0, 40, 40, 0),
                     y = c(0, 0, 40, 40))

# if no window is set, the bounding box will be set as window
aGeom <- gs_polygon(anchor = coords)
visualise(aGeom)

# derive a regular polygon from the coordinates
aPolygon <- gs_polygon(anchor = coords, vertices = 6, regular = TRUE)
visualise(aPolygon, linecol = "green")
visualise(aGeom, new = FALSE)

# the vertices are plottet relative to the window
window <- data.frame(x = c(-50, 50),
                     y = c(-50, 50))
aPolygon <- setWindow(x = aPolygon, to = window)
visualise(aPolygon, fillcol = "deeppink")

# using a geom as anchor retains its properties (such as the window)
aRectangle <- gs_rectangle(anchor = aPolygon)
visualise(aRectangle, new = FALSE)

# 2. sketch a hexagon
if(dev.interactive()){
  aHexagon <- gs_hexagon(features = 1)
  visualise(aHexagon, linecol = "deeppink", linetype = 2, new = FALSE)
}
}
\seealso{
Other geometry shapes: 
\code{\link{gs_line}()},
\code{\link{gs_point}()},
\code{\link{gs_random}()}
}
\concept{geometry shapes}
