% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCRS.R
\name{getCRS}
\alias{getCRS}
\alias{getCRS,ANY-method}
\alias{getCRS,geom-method}
\alias{getCRS,Spatial-method}
\alias{getCRS,sf-method}
\alias{getCRS,Raster-method}
\title{Get the coordinate reference system of a spatial object.}
\usage{
getCRS(x, ...)

\S4method{getCRS}{ANY}(x)

\S4method{getCRS}{geom}(x)

\S4method{getCRS}{Spatial}(x)

\S4method{getCRS}{sf}(x)

\S4method{getCRS}{Raster}(x)
}
\arguments{
\item{x}{the object from which to extract the coordinate reference system.}

\item{...}{other arguments.}
}
\value{
The coordinate reference system of \code{x} given as proj4string.
}
\description{
Get the coordinate reference system of a spatial object.
}
\examples{
getCRS(x = gtGeoms$grid$continuous)

library(sf)
nc_sf <- st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
getCRS(nc_sf)

getCRS(x = gtRasters$categorical)
}
\seealso{
Other getters: 
\code{\link{getCols}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getLayers}()},
\code{\link{getNames}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getRows}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
