% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOReferenceSystem.R
\docType{class}
\name{ISOReferenceSystem}
\alias{ISOReferenceSystem}
\title{ISOReferenceSystem}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO ReferenceSystem
}
\description{
ISOReferenceSystem
}
\section{Fields}{

\describe{
\item{\code{referenceSystemIdentifier}}{[\code{\link{ISOReferenceIdentifier}}] the reference system identifier}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, value)}}{
   This method is used to instantiate an \code{\link{ISOReferenceSystem}}
 }
 \item{\code{setReferenceSystemIdentifier(code, codeSpace)}}{
   Sets the reference system identifier
 }
}
}

\examples{
  md <- ISOReferenceSystem$new()
  rsId <- ISOReferenceIdentifier$new(code = "4326", codeSpace = "EPSG")
  md$setReferenceSystemIdentifier(rsId)
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{reference}
\keyword{system}
