% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topojson_read.R
\name{topojson_read}
\alias{topojson_read}
\title{Read topojson from a local file or a URL}
\usage{
topojson_read(x, ...)
}
\arguments{
\item{x}{Path to a local file or a URL.}

\item{...}{Further args passed on to \code{\link[rgdal]{readOGR}}}
}
\value{
A Spatial Class, varies depending on input
}
\description{
Read topojson from a local file or a URL
}
\details{
Returns a Spatial class (e.g., SpatialPolygonsDataFrame), but 
you can easily and quickly get this to geojson, see examples
}
\examples{
\dontrun{
# From a file
file <- system.file("examples", "us_states.topojson", package = "geojsonio")
topojson_read(file)

# From a URL
url <- "https://raw.githubusercontent.com/shawnbot/d3-cartogram/master/data/us-states.topojson"
topojson_read(url)

# Use as.location first if you want
topojson_read(as.location(file))

# quickly convert to geojson as a list
file <- system.file("examples", "us_states.topojson", package = "geojsonio")
tmp <- topojson_read(file)
geojson_list(tmp)
}
}

