% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{fitplane}
\alias{fitplane}
\title{Calculate a Least Squares Polynomial Surface}
\usage{
fitplane(x, order)
}
\arguments{
\item{x}{A raster or matrix.}

\item{order}{Numeric. Indicates the polynomial order to be fit.}
}
\value{
A matrix with values predicted from the polynomial fit.
}
\description{
Fits a polynomial surface of order \code{n} to a raster
or matrix.
}
\examples{
library(raster)

# import raster image
data(orforest)

# find the 2nd order least squares polynomial surface
polyfit <- fitplane(orforest, order = 2)

# create raster of polyfit
x <- setValues(orforest, polyfit)

# plot the fit
plot(x)
}
