% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georange.R
\name{georange}
\alias{georange}
\title{georange}
\usage{
georange(x, y, sequential = FALSE, measure = "cheap")
}
\arguments{
\item{x}{Rectangular object (matrix, \code{data.frame}, \pkg{tibble},
whatever) containing longitude and latitude coordinates.}

\item{y}{Optional second object which, if passed, results in distances
calculated between each object in \code{x} and each in \code{y}.}

\item{sequential}{If \code{TRUE}, calculate (vector of) distances
sequentially along \code{x} (when no \code{y} is passed), otherwise calculate
matrix of pairwise distances between all points.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation; see Notes.}
}
\value{
A named vector of two numeric values: minimum and maximum, giving the
respective distances in metres.
}
\description{
Calculate range of distances (min-max) between all points in one or two
rectangular objects containing lon-lat coordinates.
}
\note{
\code{measure = "cheap"} denotes the mapbox cheap ruler
\url{https://github.com/mapbox/cheap-ruler-cpp}; \code{measure = "geodesic"}
denotes the very accurate geodesic methods given in Karney (2013)
"Algorithms for geodesics" J Geod 87:43-55, and as provided by the
code{sf::st_dist()} function.
}
\examples{
n <- 50
x <- cbind (-10 + 20 * runif (n), -10 + 20 * runif (n))
y <- cbind (-10 + 20 * runif (2 * n), -10 + 20 * runif (2 * n))
colnames (x) <- colnames (y) <- c ("x", "y")
# All of the following returns vector of two values: minimum and maximum:
d0 <- georange (x)
d1 <- georange (x, y)
d2 <- georange (x, sequential = TRUE)
d0_2 <- georange (x, measure = "geodesic") # nanometre-accurate version of d0
}
