% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{Spectra-coerce}
\alias{Spectra-coerce}
\alias{as,Spectra}
\alias{Spectra-coerce}
\title{Conversion between \code{Spectra} and data.frame objects}
\arguments{
\item{from}{The input object}

\item{to}{Name of the class of output object}
}
\description{
Converting \code{Spectra} object to data.frame is straightforward 
while the conversion in the opposite direction requires a set of attributes
to be present in the source data.frame object.
These attributes are generally created during the conversion of a
\code{Spectra} object into data.frame, they can 
also be manually set if they are non-existant (see the example below).
}
\examples{
#Convert a Spectra object to data.frame
sp <- spc.example_spectra()
df <- as(sp, "data.frame")
class(df); dim(df)
attributes(df)

#Convert the data.frame back to Spectra
sp2 <- as(df, "Spectra")
sp2

#Convert a bare data.frame to Spectra with minimal attributes
df2 <- data.frame(ch1=c(1,2,3,4), ch2=c(5,6,7,8), TIME=Sys.time()+1:4, LAT=1:4, LON=5:8)
attr(df2, "Units") <- "m-1"
attr(df2, "Wavelengths") <- c(500, 600)
attr(df2, "ShortName") <- "abs"
as(df2, "Spectra")
}
