% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{bf2new}
\alias{bf2new}
\title{Compute the Bayes factors at other points}
\usage{
bf2new(bfspobj, linkp, phi, omg, kappa, useCV = TRUE)
}
\arguments{
\item{bfspobj}{Output from the function \code{\link{bf1skel}} which
contains the Bayes factors and importance sampling weights.}

\item{linkp,phi,omg,kappa}{Scalar or vector or \code{NULL}. If
scalar or vector, the Bayes factors are calculated at those
values. If \code{NULL} then the unique values from the MCMC
chains that were inputted in \code{\link{bf1skel}} will be used.}

\item{useCV}{Whether to use control variates for finer
corrections.}
}
\value{
An array of size length(linkp) x length(phi) x length(omg)
x length(kappa) containing the Bayes factors for each combination
of the parameters.
}
\description{
Compute the Bayes factors.
}
\details{
Computes the Bayes factors using the importance weights.
}
\references{
Doss, H. (2010). Estimation of large families of Bayes
factors from Markov chain output. \emph{Statistica Sinica}, 20(2),
537.
}

