% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_varlist.r
\name{structure_varlist}
\alias{structure_varlist}
\title{creates a formula object from a varlist, mostly for internal use.}
\usage{
structure_varlist(x, type = "formula")
}
\arguments{
\item{x}{the varlist to be converted in "var1 var2 var3" format.  Can be specified using the \emph{globbing} characters "*" (match zero or more of any character) or "?" (match any single character) like "var*" or "var?" for "var1 var2 var3" or using regular expressions if \code{regex=TRUE} ("var[0-9]+" = "var1 var2 var3").}

\item{type}{if "formula", return a varlist in formula format; if "vector", return a varlist in character vector format.}
}
\value{
a formula object which can be passed to \code{model.frame} or a character vector giving the name of each variable
}
\description{
A varlist in \code{genvar} is a space-separated string potentially with wildcard characters, "var1 var2 var3 x*".  This function converts a varlist to a formula or to a vector.
}
\examples{
use(cars, clear=TRUE)
structure_varlist("speed dist", type="formula")
structure_varlist("speed dist", type="vector")
structure_varlist("*", type="vector")
}
