% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.r
\name{gen}
\alias{gen}
\title{generates a new variable that is a transformation of existing variables in the dataset or replaces one}
\usage{
gen(var, value, byvar = NULL, subset = NULL, replace = FALSE)
}
\arguments{
\item{var}{the name of the variable to be generated}

\item{value}{the transformation of the dataset to replace the "newvar" in option \code{form} with.  For example,  value="sum(wage*female)" to get a variable which has total female wages.  In Stata, the same command would be: "egen femalewage = total(wage*female)".}

\item{byvar}{apply the value for each level of the by variables, specified either as a formula, like ~byvar1+byvar2+... or as a varlist "byvar1 byvar2 byvar3...".}

\item{subset}{only generate values if the condition provided in subset is true.  Make sure to enclose the expression in quotes, like so: subset="female==1 & highschool==1" to generate the values only for women who graduated from highschool.  This option is used like the "if" in Stata.}

\item{replace}{either TRUE or FALSE.  If FALSE (default), the code refuses to alter the variable if the variable already exists.  Otherwise, if replace=TRUE, then the values will be replaced.}
}
\value{
returns NULL, invisibly
}
\description{
generates a new variable that is a transformation of existing variables in the dataset or replaces one
}
