% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fun_splitopt.pls.R
\name{splitopt.pls}
\alias{splitopt.pls}
\title{Defining optimum partition for a specific variable.}
\usage{
splitopt.pls(
  x,
  inner,
  outer,
  mode,
  scheme,
  scaling,
  scaled,
  splits,
  fact,
  method,
  n.node,
  ...
)
}
\arguments{
\item{x}{matrix or data frame containing the data.}

\item{inner}{A square (lower triangular) boolean matrix representing the inner 
model (i.e. the path relationships between latent variables).}

\item{outer}{list of vectors with column indices or column names from Data indicating 
the sets of manifest variables forming each block (i.e. which manifest variables correspond to each block).}

\item{mode}{character vector indicating the type of measurement for each
block. Possible values are: \code{"A", "B", "newA", "PLScore", "PLScow"}. 
The length of \code{mode} must be equal to the length of \code{outer}.}

\item{scheme}{string indicating the type of inner weighting
scheme. Possible values are \code{"centroid"}, \code{"factorial"}, or
\code{"path"}.}

\item{scaling}{optional list of string vectors indicating the type of 
measurement scale for each manifest variable specified in \code{blocks}.
\code{scaling} must be specified when working with non-metric variables.
Possible values: \code{"num"} (numeric), \code{"raw"}, \code{"nom"} (nominal), 
and \code{"ord"} (ordinal).}

\item{scaled}{whether manifest variables should be standardized. 
Only used when \code{scaling = NULL}. When (\code{TRUE}, data is 
scaled to standardized values (mean=0 and variance=1).}

\item{splits}{vector indicating the binary partition}

\item{fact}{vector indicating the variable}

\item{method}{string indicating the method: LM or LAD}

\item{n.node}{number indicating a stop condition}

\item{\dots}{Further arguments passed on to \code{\link{splitopt.pls}}.}
}
\value{
list containing information of the optimum partition for a specific variable
}
\description{
Defining optimum partition for a specific variable.
}
\details{
Internal function. \code{splitopt.pls} is called by \code{all.part.pls}.
}
\keyword{internal}
