% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grep_df_subset.R
\name{grep_df_subset}
\alias{grep_df_subset}
\title{Internal function to remove search and remove columns based on names}
\usage{
grep_df_subset(x, toMatch)
}
\arguments{
\item{x}{data frame where columns are to be removed}

\item{toMatch}{vector of characters to remove from x}
}
\value{
A subset of a genotypeR object
}
\description{
\code{grep_df_subset} is an internal function that subsets
a data frame based on supplied pattern. This function is
provided in case it is found useful.
}
\examples{

df <- data.frame(one=rep(1,5), two=rep(1,5), three=rep(1,5), four=rep(1,5))
toMatch <- paste(c("one", "two"), collapse="|")
##remove toMatch
grep_df_subset(df, toMatch)

}
\keyword{columns}
\keyword{matching}
\keyword{remove}
