% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/albums.R
\name{get_album_tracklist_id}
\alias{get_album_tracklist_id}
\title{Retrieve an album's tracklisting}
\usage{
get_album_tracklist_id(album_id, access_token = genius_token())
}
\arguments{
\item{album_id}{ID of the album (\code{album_id} within an object returned by
\code{\link{get_song}})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a tibble
}
\description{
Get an album's tracklisting, and song meta data, given an album ID.
}
\examples{
\dontrun{
get_album_tracklist_id(album_id = 337082)
}
}
\seealso{
See \code{\link{get_album_tracklist_search}} to search for
an album tracklist by searching artist/album names.

Other album: 
\code{\link{get_album_df}()},
\code{\link{get_album_tracklist_search}()},
\code{\link{get_album}()}
}
\concept{album}
