% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_to_fam.R
\name{ind_to_fam}
\alias{ind_to_fam}
\title{Convert an eigenstrat IND tibble into a plink FAM tibble}
\usage{
ind_to_fam(ind)
}
\arguments{
\item{ind}{The input eigenstrat IND tibble to convert.}
}
\value{
A plink FAM tibble.
}
\description{
This function takes an existing IND tibble and creates a FAM tibble with the same information and dummy values for missing data.
In particular, the output FAM tibble will contain these columns with these contents:
\describe{
\item{fam:}{ IND label }
\item{id:}{ IND id }
\item{pat:}{ \code{0} (missing paternal ID) }
\item{mat:}{ \code{0} (missing maternal ID) }
\item{sex:}{ IND sex converted to plink integer codes via \code{\link{sex_to_int}} }
\item{peno:}{ \code{0} (missing phenotype) }
}
As IND tibbles only contain the three columns listed above, there is no loss of information.
}
\examples{
# create a sample IND tibble
library(tibble)
ind <- tibble(
  id = 1:3,
  sex = c('U', 'M', 'F'),
  label = c(1, 1, 2)
)
# convert to FAM
fam <- ind_to_fam(ind)
# inspect:
fam

}
\seealso{
\code{\link{sex_to_int}}

Eigenstrat IND format reference:
\url{https://github.com/DReichLab/EIG/tree/master/CONVERTF}

Plink FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#fam}
}
