% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acuttrfn.R
\name{acuttrfn}
\alias{acuttrfn}
\title{Alpha-cut of trapezoidal fuzzy number}
\usage{
acuttrfn(left, lmid, rmid, right, acut.level = seq(0, 1, by = 0.1))
}
\arguments{
\item{left}{the left point of trapezoidal fuzzy number}

\item{lmid}{the left-middle point of trapezoidal fuzzy number}

\item{rmid}{the right-middle point of trapezoidal fuzzy number}

\item{right}{the right point of trapezoidal fuzzy number}

\item{acut.level}{the alpha-cut level of trapezoidal fuzzy number}
}
\value{
\code{AL} is alpha-cut level,
            \code{XL.AL} is a lower alpha-cut point of trapezoidal fuzzy number,
        and \code{XU.AL} is a upper alpha-cut point of trapezoidal fuzzy number.
}
\description{
This function for calculating alpha-cut of trapezoidal fuzzy number. See detail in references.
}
\examples{
acuttrfn(1,2,3,5,acut.level = c(0,0.5,1))
acuttrfn(1,2.5,3.5,6,acut.level = c(0.00,0.25,0.50,0.75,1.00))
}
\references{
Klir, G.J., Yuan, B., & H., S.C.U. (1997). Fuzzy set theory: Foundations and applications. Prentice Hall PTR.
}
