% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_LDheatmap.R
\name{LDheatmap}
\alias{LDheatmap}
\alias{plot_LDheatmap}
\title{This function produces a pairwise LD plot.}
\usage{
plot_LDheatmap(
  hap,
  gff,
  Chr,
  start,
  end,
  geneID = NULL,
  distances = "physical",
  LDmeasure = "r",
  title = "Pairwise LD",
  add.map = TRUE,
  map.height = 1,
  colorLegend = TRUE,
  geneMapLocation = 0.15,
  geneMapLabelX = NULL,
  geneMapLabelY = NULL,
  SNP.name = TRUE,
  color = NULL,
  color_gmodel = "grey",
  color_snp = "grey",
  color_snpname = "grey40",
  cex_snpname = 0.8,
  snpmarks_height = NULL,
  newpage = TRUE,
  name = "ldheatmap",
  vp.name = NULL,
  pop = FALSE,
  text = FALSE
)
}
\arguments{
\item{hap}{R object of hapSummary or hapResult class.}

\item{gff}{annotations}

\item{Chr, start, end, geneID}{chromosome, start and end position, gene ID for
extract annotation in target range.}

\item{distances}{A character string to specify whether the provided map locations
are in physical or genetic distances.
If \code{distances = "physical"} (default), the text describing the total
length of the region will be \dQuote{Physical Length:XXkb} where XX is the
length of the region in kilobases. If \code{distances = "genetic"}, the
text will be \dQuote{Genetic Map Length:YYcM} where YY is
the length of the region in centiMorgans.
If \code{gdat} is an object of class LDheatmap,
\code{distances} is taken from \code{gdat}.}

\item{LDmeasure}{A character string specifying the measure of LD
\itemize{
\item either allelic correlation \eqn{r^2} or Lewontin's
|D\eqn{'}|; default = \code{"r"} for \eqn{r^2};
type \code{"D'"} for |D\eqn{'}|. This argument is ignored when the user has already
supplied calculated LD measurements through \code{gdat} (i.e., when \code{gdat}
is a matrix of pairwise LD measurements or an object of class \code{"LDheatmap"}).
}}

\item{title}{A character string for the main title of the plot.
Default is \dQuote{Pairwise LD}.}

\item{add.map}{If \code{TRUE} (default) a diagonal line indicating
the physical or genetic map positions of the SNPs will be added to
the plot, along with text indicating the total length of the
genetic region.}

\item{map.height}{the height of gene map, default is 0.02}

\item{colorLegend}{If \code{TRUE} (default) the color legend is drawn.}

\item{geneMapLocation}{A numeric value specifying the position of the line
parallel to the diagonal of the matrix; the larger the value, the
farther it lies from the matrix diagonal. Ignored when \code{add.map = FALSE}.}

\item{geneMapLabelX}{A numeric value specifying the x-coordinate
of the text indicating the total length of the genomic region
being considered. Ignored when \code{add.map = FALSE}.}

\item{geneMapLabelY}{A numeric value specifying the y-coordinate
of the text indicating the total length of the genomic region
being considered. Ignored when \code{add.map = FALSE}.}

\item{SNP.name}{a logical vector indicated wherther display SNP names using positions.}

\item{color}{A range of colors to be used for drawing the heat map. Default
is \code{grDevices::colorRampPalette(c("red", "grey"))(30)}.}

\item{color_gmodel, color_snp, color_snpname}{the color of gene model and snp and snp names respectively, default as grey80.}

\item{cex_snpname}{the size of snp names/labels}

\item{snpmarks_height}{the height of snp marks, if set as NULL, nothing will display on gene model
where the heat map is going to be drawn.}

\item{newpage}{If \code{TRUE} (default), the heat map will be drawn on a new page.}

\item{name}{A character string specifying the name of the LDheatmap
graphical object (\code{grob}) to be produced.}

\item{vp.name}{A character string specifying the name of the viewport}

\item{pop}{If \code{TRUE}, the viewport where the heat map is drawn is
\code{pop}ped (i.e. removed) from the viewport tree after drawing.
Default = \code{FALSE}.}

\item{text}{If \code{TRUE}, the LD measurements are printed on each cell.}
}
\value{
An object of class \code{"LDheatmap"} which contains the following components:
\item{LDmatrix}{ The matrix of pairwise LD measurements plotted in the heat map. }
\item{LDheatmapGrob}{ A grid graphical object (grob) representing the produced heat map. }
\item{heatmapVP}{ The viewport in which the heat map is drawn. See \link[grid:viewport]{viewport}.}
\item{genetic.distances}{The vector of the supplied physical or
genetic map locations, or the vector of equispaced marker distances
when no distance vector is supplied.}
\item{distances}{ A character string specifying whether the provided map
distances are physical or genetic. }
\item{color}{ The range of colors used for drawing the heat map. }
The \code{grob} \code{LDheatmapGrob} has three \code{grob}s as its children (components).
They are listed below along with their own children and respectively represent
the color image with main title, genetic map and color key of the heat map:
\code{"heatMap"} - \code{"heatmap"}, \code{"title"};
\code{"geneMap"} - \code{"diagonal"}, \code{"segments"},
\code{"title"}, \code{"symbols"}, \code{"SNPnames"}; and
\code{"Key"} - \code{"colorKey"}, \code{"title"}, \code{"labels"},
\code{"ticks"}, \code{"box"}.
}
\description{
\code{LDheatmap()} is used to produce a graphical display, as a heat map,
of pairwise linkage disequilibrium (LD) measurements for SNPs.
The heat map is a false color image in the upper-left diagonal of a square plot.
Optionally, a line parallel to the diagonal of the image indicating
the physical or genetic map positions of the SNPs may be added, along
with text reporting the total length of the genomic region considered.
}
\details{
The input object \code{gdat} can be a data frame of \code{genotype} objects
(a data structure from the \pkg{genetics} package), a \code{SnpMatrix} object
(a data structure from the \pkg{snpStats} package), or
any square matrix with values between 0 and 1 inclusive.
LD computation is much faster for \code{SnpMatrix} objects than for
\code{genotype} objects.
In the case of a matrix of LD values between 0 and 1,
the values above the diagonal will be plotted.
In the display of LD, SNPs appear in the order supplied by the
user as the horizontal and vertical coordinates are increased
and one moves along the off-diagonal line, from the bottom-left
to the top-right corner. To achieve this, the conventions of
the \code{image()} function have been adopted, in which horizontal
coordinates correspond to the rows of the matrix and vertical coordinates
correspond to columns, and vertical coordinates are indexed in increasing
order from bottom to top.
See the package vignette \code{LDheatmap} for more examples and details
of the implementation. Examples of adding ``tracks'' of genomic
annotation above a flipped heatmap are in the package vignette
\code{addTracks}.
}
\note{
The produced heat map can be modified in two ways.
First, it is possible to edit \emph{interactively} the grob components of the heat map,
by using the function \code{\link[grid:grid.edit]{grid.edit}};
the function will not work if there is no
open graphical device showing the heat map.
Alternatively, the user can use the function
\code{\link[grid:grid.edit]{editGrob}} and work with
the grob \code{LDheatmapGrob} returned by \code{LDheatmap}.
See Examples for usage.
\code{LDheatmap()} uses \code{\link[grid:Grid]{Grid}}, which
does not respond to \code{par()} settings.
Hence modifying \code{par()} settings of \code{mfrow} and \code{mfcol}
will not work with \code{LDheatmap()}. The Examples section shows how to
display multiple heat maps on one plot without the use
of \code{par()}.
}
\examples{
# Pass LDheatmap a SnpMatrix object
data(geneHapR_test)
plot_LDheatmap(hap = hapResult,
               gff = gff,
               Chr = hapResult[1,2],
               start = 4000, end = 8200)
}
\references{
Shin J-H, Blay S, McNeney B and Graham J (2006). LDheatmap:
An R Function for Graphical Display of Pairwise Linkage
Disequilibria Between Single Nucleotide Polymorphisms.
Journal of Statistical Software, \bold{16} Code Snippet 3
}
