/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.iterators;

import java.lang.reflect.Array;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections15.ResettableListIterator;
import org.apache.commons.collections15.iterators.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListIterator<E>
extends ArrayIterator<E>
implements ListIterator<E>,
ResettableListIterator<E> {
    protected int lastItemIndex = -1;

    public ArrayListIterator() {
    }

    public ArrayListIterator(Object array) {
        super(array);
    }

    public ArrayListIterator(Object array, int startIndex) {
        super(array, startIndex);
        this.startIndex = startIndex;
    }

    public ArrayListIterator(Object array, int startIndex, int endIndex) {
        super(array, startIndex, endIndex);
        this.startIndex = startIndex;
    }

    @Override
    public boolean hasPrevious() {
        return this.index > this.startIndex;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastItemIndex = --this.index;
        return (E)Array.get(this.array, this.index);
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastItemIndex = this.index;
        return (E)Array.get(this.array, this.index++);
    }

    @Override
    public int nextIndex() {
        return this.index - this.startIndex;
    }

    @Override
    public int previousIndex() {
        return this.index - this.startIndex - 1;
    }

    @Override
    public void add(E o) {
        throw new UnsupportedOperationException("add() method is not supported");
    }

    @Override
    public void set(E o) {
        if (this.lastItemIndex == -1) {
            throw new IllegalStateException("must call next() or previous() before a call to set()");
        }
        Array.set(this.array, this.lastItemIndex, o);
    }

    @Override
    public void reset() {
        super.reset();
        this.lastItemIndex = -1;
    }
}

