% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertex.R
\name{token.vertex}
\alias{token.vertex}
\title{Generate Gemini Access Token and Endpoint URL}
\usage{
token.vertex(jsonkey = NULL, model_id = NULL, expTime = 3600)
}
\arguments{
\item{jsonkey}{A path to JSON file containing the service account key from Vertex AI.}

\item{model_id}{The ID of the Gemini model. This will be prepended with "gemini-".}

\item{expTime}{The expiration time of the access token in seconds (default is 3600 seconds, or 1 hour).}
}
\value{
A list containing:
\item{key}{The generated access token.}
\item{url}{The endpoint URL for the Gemini model.}
}
\description{
Generates an access token for the Gemini model and constructs the corresponding endpoint URL.
}
\examples{
\dontrun{
library(gemini.R)
tokens <- token.vertex(jsonkey = "YOURAPIKEY.json", model_id = "1.5-flash")

}


}
