`fit.pagel` <-
function(data, print=TRUE)
{
	bounds 	<- data$design$bounds
	model 	<- data$design$model
	np 		<- sum(model)
	n 		<- length(data$obs)
	#--- INITIALIZE RESULTS MATRIX --
    results <- matrix(nrow=2+np, ncol=4)
    colnames(results)<- c("Estimates", "SE", "Low.CI", "Upper.CI")
    rownames(results)<- c("mu", "beta", c("lambda", "kappa", "delta", "alpha")[model])
	#----- MINIMIZE NEGATIVE LOG LIKELIHOOD
	theta.start <-c(0, 0.1,c(0.5, 0.5, 0.5)[model])     # Starting point for profile search
	out         <- NULL
	out	<- nlm(negloglike, theta.start, hessian=TRUE, data=data)
	
	model.full <-c(TRUE, model)
	bounds <- t(bounds)
	#----------------------------------------
	#-----  POINT ESTIMATES & VARIANCES -----
	#----------------------------------------
	results[1,1]	<- 	out$estimate[1]			   #---   MU - No back transformation
	i <- 1
	while (i < sum(model) + 2){
		i <- i+1
		results[i,1] <-	inv.logit(out$estimate[i], 
								min=bounds[which(model.full)[i-1],1], 
								max=bounds[which(model.full)[i-1],2]
							)
	}
	#----- VARIANCE AND CI, REGULR PARAMETER SPACE
	par.var			<-	NULL
	inv.fish.info 	<- solve(out$hessian)     # inverse of fisher info = variance if untransformed
	fit.var 		<- diag(inv.fish.info)   
	par.var[1]  	<- fit.var[1]             # variance of mu untransformed
	i <- 1
	while (i < sum(model)+2){
		i <- i+1
		y <- out$estimate[i]
		#--- Delta Transformation of error term
		par.var[i]  <- fit.var[i]*(((exp(y)*(1+exp(y))-exp(2*y))/(1+exp(y))^2) * 
						(bounds[which(model.full)[i-1],2] - bounds[which(model.full)[i-1],1]))^2
	}	
	#-------- CONFIDENCE INTERVALS -----
	conf.level  <- 0.95
	crit.val    <- qnorm((1 + conf.level) / 2)
	for (i in 1:length(out$estimate))
	{
		results[i,2]   <- round(sqrt(par.var[i]), digits=4)
	   	results[i,3:4] <- results[i,1] + c(-1, 1) * crit.val *sqrt(par.var[i])
	}
	#----------------------------------------
	#--- OUTPUT RESULTS (PRINT OR RETURN) ---
	#----------------------------------------
	if (print==TRUE){
		print(paste("Maximum Likelihood:", round(-out$minimum, digits=3)), quote=FALSE)
		print(results)
	}else{
	 	return(list(estimates=results, lnl=-out$minimum)) 
	}
}

