% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{g_transform}
\alias{g_transform}
\title{Apply a coordinate transformation to a WKB/WKT geometry}
\usage{
g_transform(
  geom,
  srs_from,
  srs_to,
  wrap_date_line = FALSE,
  date_line_offset = 10L,
  traditional_gis_order = TRUE,
  as_wkb = TRUE,
  as_iso = FALSE,
  byte_order = "LSB",
  quiet = FALSE
)
}
\arguments{
\item{geom}{Either a raw vector of WKB or list of raw vectors, or a
character vector containing one or more WKT strings.}

\item{srs_from}{Character string specifying the spatial reference system
for \code{geom}. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}

\item{srs_to}{Character string specifying the output spatial reference
system. May be in WKT format or any of the formats supported by
\code{\link[=srs_to_wkt]{srs_to_wkt()}}.}

\item{wrap_date_line}{Logical value, \code{TRUE} to correct geometries that
incorrectly go from a longitude on a side of the antimeridian to the other
side. Defaults to \code{FALSE}.}

\item{date_line_offset}{Integer longitude gap in degree. Defaults to \code{10L}.}

\item{traditional_gis_order}{Logical value, \code{TRUE} to use traditional GIS
order of axis mapping (the default) or \code{FALSE} to use authority compliant
axis order. By default, input \code{geom} vertices are assumed to
be in longitude/latitude order if \code{srs_from} is a geographic coordinate
system. This can be overridden by setting \code{traditional_gis_order = FALSE}.}

\item{as_wkb}{Logical value, \code{TRUE} to return the output geometry in WKB
format (the default), or \code{FALSE} to return as WKT.}

\item{as_iso}{Logical value, \code{TRUE} to export as ISO WKB/WKT (ISO 13249
SQL/MM Part 3), or \code{FALSE} (the default) to export as "Extended WKB/WKT".}

\item{byte_order}{Character string specifying the byte order when output is
WKB. One of \code{"LSB"} (the default) or \code{"MSB"} (uncommon).}

\item{quiet}{Logical value, \code{TRUE} to suppress warnings. Defaults to \code{FALSE}.}
}
\value{
A geometry as WKB raw vector or WKT string, or a list/character vector of
geometries as WKB/WKT with length equal to the number of input geometries.
\code{NA} is returned with a warning if WKB input cannot be converted into an
OGR geometry object, or if an error occurs in the call to the underlying
OGR API.
}
\description{
\code{g_transform()} will transform the coordinates of a geometry from their
current spatial reference system to a new target spatial reference system.
Normally this means reprojecting the vectors, but it could include datum
shifts, and changes of units.
}
\note{
This function uses the \code{OGR_GeomTransformer_Create()} and
\code{OGR_GeomTransformer_Transform()} functions in the GDAL API: "This is an
enhanced version of \code{OGR_G_Transform()}. When reprojecting geometries from
a Polar Stereographic projection or a projection naturally crossing the
antimeridian (like UTM Zone 60) to a geographic CRS, it will cut geometries
along the antimeridian. So a \code{LineString} might be returned as a
\code{MultiLineString}."

The \code{wrap_date_line = TRUE} option might be specified for circumstances to
correct geometries that incorrectly go from a longitude on a side of the
antimeridian to the other side, e.g., \verb{LINESTRING (-179 0,179 0)} will be
transformed to \verb{MULTILINESTRING ((-179 0,-180 0),(180 0,179 0))}. For that
use case, \code{srs_to} might be the same as \code{srs_from}.
}
\examples{
pt <- "POINT (-114.0 47.0)"
g_transform(pt, "WGS84", "EPSG:5070", as_wkb = FALSE)

# correct geometries that incorrectly go from a longitude on a side of the
# antimeridian to the other side
geom <- "LINESTRING (-179 0,179 0)"
g_transform(geom, "WGS84", "WGS84", wrap_date_line = TRUE, as_wkb = FALSE)
}
\seealso{
\code{\link[=bbox_transform]{bbox_transform()}}, \code{\link[=transform_bounds]{transform_bounds()}}
}
