% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_create.R
\name{create}
\alias{create}
\title{Create a new uninitialized raster}
\usage{
create(
  format,
  dst_filename,
  xsize,
  ysize,
  nbands,
  dataType,
  options = NULL,
  return_obj = FALSE
)
}
\arguments{
\item{format}{Character string giving a raster format short name
(e.g., \code{"GTiff"}).}

\item{dst_filename}{Character string giving the filename to create.}

\item{xsize}{Integer width of raster in pixels.}

\item{ysize}{Integer height of raster in pixels.}

\item{nbands}{Integer number of bands.}

\item{dataType}{Character string containing the data type name.
(e.g., common data types include Byte, Int16, UInt16, Int32, Float32).}

\item{options}{Optional list of format-specific creation options in a
character vector of \code{"NAME=VALUE"} pairs
(e.g., \code{options = c("COMPRESS=LZW")} to set LZW
compression during creation of a GTiff file).
The APPEND_SUBDATASET=YES option can be
specified to avoid prior destruction of existing dataset.}

\item{return_obj}{Logical scalar. If \code{TRUE}, an object of class
\code{\link{GDALRaster}} opened on the newly created dataset will be
returned, otherwise returns a logical value. Defaults to \code{FALSE}.}
}
\value{
By default, returns a logical value indicating success (invisible
\code{TRUE}, output written to \code{dst_filename}). An error is raised if the
operation fails. An object of class \code{\link{GDALRaster}} open on the
output dataset will be returned if \code{return_obj = TRUE}.
}
\description{
\code{create()} makes an empty raster in the specified format.
}
\note{
\code{dst_filename} may be an empty string (\code{""}) with \code{format = "MEM"} and
\code{return_obj = TRUE} to create an In-memory Raster
(\url{https://gdal.org/en/stable/drivers/raster/mem.html}).
}
\examples{
new_file <- file.path(tempdir(), "newdata.tif")
ds <- create(format="GTiff",
             dst_filename = new_file,
             xsize = 143,
             ysize = 107,
             nbands = 1,
             dataType = "Int16",
             return_obj=TRUE)

# EPSG:26912 - NAD83 / UTM zone 12N
ds$setProjection(epsg_to_wkt(26912))

gt <- c(323476, 30, 0, 5105082, 0, -30)
ds$setGeoTransform(gt)

ds$setNoDataValue(band = 1, -9999)
ds$fillRaster(band = 1, -9999, 0)

# ...

# close the dataset when done
ds$close()
\dontshow{deleteDataset(new_file)}
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=createCopy]{createCopy()}}, \code{\link[=getCreationOptions]{getCreationOptions()}},
\code{\link[=rasterFromRaster]{rasterFromRaster()}}
}
