% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{buildVRT}
\alias{buildVRT}
\title{Build a GDAL virtual raster from a list of datasets}
\usage{
buildVRT(vrt_filename, input_rasters, cl_arg = NULL, quiet = FALSE)
}
\arguments{
\item{vrt_filename}{Character string. Filename of the output VRT.}

\item{input_rasters}{Character vector of input raster filenames.}

\item{cl_arg}{Optional character vector of command-line arguments to
\code{gdalbuildvrt}.}

\item{quiet}{Logical scalar. If \code{TRUE}, a progress bar will not be
displayed. Defaults to \code{FALSE}.}
}
\value{
Logical indicating success (invisible \code{TRUE}).
An error is raised if the operation fails.
}
\description{
\code{buildVRT()} is a wrapper of the \command{gdalbuildvrt} command-line
utility for building a VRT (Virtual Dataset) that is a mosaic of the list
of input GDAL datasets
(see \url{https://gdal.org/en/stable/programs/gdalbuildvrt.html}).
}
\details{
Several command-line options are described in the GDAL documentation at the
URL above. By default, the input files are considered as tiles of a larger
mosaic and the VRT file has as many bands as one of the input files.
Alternatively, the \code{-separate} argument can be used to put each input
raster into a separate band in the VRT dataset.

Some amount of checks are done to assure that all files that will be put in
the resulting VRT have similar characteristics: number of bands,
projection, color interpretation.... If not, files that do not match the
common characteristics will be skipped. (This is true in the default
mode for virtual mosaicing, and not when using the \code{-separate} option).

In a virtual mosaic, if there is spatial overlap between
input rasters then the order of files appearing in the list of
sources matter: files that are listed at the end are the ones
from which the data will be fetched. Note that nodata will be taken into
account to potentially fetch data from less priority datasets.
}
\examples{
# build a virtual 3-band RGB raster from individual Landsat band files
b4_file <- system.file("extdata/sr_b4_20200829.tif", package="gdalraster")
b5_file <- system.file("extdata/sr_b5_20200829.tif", package="gdalraster")
b6_file <- system.file("extdata/sr_b6_20200829.tif", package="gdalraster")
band_files <- c(b6_file, b5_file, b4_file)
vrt_file <- file.path(tempdir(), "storml_b6_b5_b4.vrt")
buildVRT(vrt_file, band_files, cl_arg = "-separate")
ds <- new(GDALRaster, vrt_file)
ds$getRasterCount()
plot_raster(ds, nbands=3, main="Landsat 6-5-4 (vegetative analysis)")
ds$close()
\dontshow{vsi_unlink(vrt_file)}
}
\seealso{
\code{\link[=rasterToVRT]{rasterToVRT()}}
}
