% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_collection_ops.R
\name{translate_gtiff}
\alias{translate_gtiff}
\title{Convert complete image collections to cloud-optimized GeoTIFFs}
\usage{
translate_gtiff(
  collection,
  target_dir = tempfile(pattern = "image_collection_"),
  overwrite = TRUE,
  creation_options = c("TILED=YES", "COMPRESS=DEFLATE", "ZLEVEL=1",
    "COPY_SRC_OVERVIEWS=TRUE")
)
}
\arguments{
\item{collection}{path to an existing image collection file}

\item{target_dir}{directory where the output will be stored, will be created if necessary}

\item{overwrite}{logical; if TRUE existing files will be overwritten}

\item{creation_options}{further settings of the GDAL GTiff driver; see \url{https://gdal.org/drivers/raster/gtiff.html}}
}
\value{
path to the new image collection file for use as argument to \code{\link{image_collection}}
}
\description{
This function translates all images of a gdalcubes image collection to GeoTIFF files.
The output contains converted imagery as an additional copy (original files are not deleted) and
a new image collection file.
}
\details{
The functions \code{\link{translate_gtiff}} and \code{\link{translate_cog}} have the same purpose to convert imagery to optimized GeoTIFF files. The latter uses the recent COG GDAL driver,
whereas the former uses the normal GTiff driver. Depending on additional creation options and the input images, files creted with \code{\link{translate_gtiff}} may or may not contain overview images.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
L8.col

\donttest{
L8.tif.col = translate_gtiff(L8.col)
L8.tif.col
}

}
