% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{read_blocks}
\alias{read_blocks}
\title{Read blockmeasures}
\usage{
read_blocks(
  files,
  filetype = NULL,
  startrow = NULL,
  endrow = NULL,
  startcol = NULL,
  endcol = NULL,
  sheet = NULL,
  metadata = NULL,
  block_names = NULL,
  block_names_header = "block_name",
  block_names_dot = FALSE,
  block_names_path = TRUE,
  block_names_ext = FALSE,
  header = NA,
  sider = NA,
  wellnames_numeric = FALSE,
  na.strings = c("NA", ""),
  extension,
  block_name_header,
  ...
)
}
\arguments{
\item{files}{A vector of filepaths relative to the current working directory
where each filepath is a single plate read}

\item{filetype}{(optional) the type(s) of the files. Options include:

                 "csv", "xls", or "xlsx".
                 
                 "tbl" or "table" to use \code{read.table} to read the file,
                 "csv2" to use \code{read.csv2}, "delim" to 
                 use \code{read.delim}, or "delim2" to use \code{read.delim2}.
                 
                 If none provided, \code{read_blocks} will infer filetype(s) 
                 from the extension(s) in \code{files}. When extension is 
                 not "csv", "xls", or "xlsx", will use "table".}

\item{startrow, endrow, startcol, endcol}{(optional) the rows and columns where 
the measures data are located in \code{files}.

Can be a vector or list the same length as \code{files}, or
a single value that applies to all \code{files}. Values
can be numeric or a string that will be automatically
converted to numeric by \code{from_excel}.

If not provided, data is presumed to begin on the first
row and column of the file(s) and end on the last row and
column of the file(s).}

\item{sheet}{(optional) If data is in .xls or .xlsx files, which sheet it 
is located on. Defaults to the first sheet if not specified}

\item{metadata}{(optional) non-spectrophotometric data that should be 
associated with each read blockmeasures. A named list where 
each item in the list is either: a vector of length 2, or
a list containing two vectors. 

In the former case, each vector should provide the row and 
column where the metadata is located in all of the
blockmeasures input files.

In the latter case, the first vector should provide the rows
where the metadata is located in each of the corresponding
input files, and the second vector should provide the 
columns where the metadata is located in each of the
corresponding input files. (This case is typically used 
when reading multiple blocks from a single file.)}

\item{block_names}{(optional) vector of names corresponding to each plate
in \code{files}. If not provided, block_names are inferred
from the filenames}

\item{block_names_header}{The name of the metadata field containing the
\code{block_names}}

\item{block_names_dot}{If block_names are inferred from filenames, should 
the leading './' (if any) be retained}

\item{block_names_path}{If block_names are inferred from filenames, should 
the path (if any) be retained}

\item{block_names_ext}{If block_names are inferred from filenames, should 
the file extension (if any) be retained}

\item{header}{\code{TRUE}, \code{FALSE}, or \code{NA}, or a vector of
such values, indicating whether the file(s) contains the
column names as its first line. If \code{header = NA}
will attempt to infer the presence of column names. If
\code{header = FALSE} or no column names are inferred when 
\code{header = NA}, column names will be generated
automatically according to \code{wellnames_numeric}}

\item{sider}{\code{TRUE}, \code{FALSE}, or \code{NA}, or a vector of
such values, indicating whether the file(s) contains the
row names as its first column. If \code{sider = NA}
will attempt to infer the presence of row names. If
\code{sider = FALSE} or no row names are inferred when 
\code{sider = NA}, row names will be generated
automatically according to \code{wellnames_numeric}}

\item{wellnames_numeric}{If row names and column names are not provided in the
input dataframe as specified by \code{header}
and \code{sider}, then names will be generated
automatically according to \code{wellnames_numeric}.

If \code{wellnames_numeric} is TRUE, rows and columns
will be numbered with "R" and "C" prefixes, respectively.

If \code{wellnames_numeric} is FALSE, rows will be
lettered A through Z, while columns will be numbered}

\item{na.strings}{A character vector of strings which are to be interpreted
as \code{NA} values by \code{utils::read.csv},
\code{readxl::read_xls}, \code{readxl::read_xlsx},
or \code{utils::read.table}}

\item{extension}{Allowed for backward compatibility; \code{filetype} is
now the preferred argument name.}

\item{block_name_header}{Allowed for backward compatibility; 
\code{block_names_header} is now the preferred argument name.}

\item{...}{Other arguments passed to \code{utils::read.csv},
\code{readxl::read_xls}, \code{readxl::read_xlsx},
or \code{utils::read.table}}
}
\value{
A list where each entry is a list containing the block data frame
        followed by the block_names (or filenames, if block_names is not 
        provided) and any specified metadata.
}
\description{
A function that reads block measures into the R environment
}
\details{
For metadata, \code{read_blocks} can handle an arbitrary number of additional
 pieces of information to extract from each blockcurve file as metadata.
 These pieces of information are specified as a named list of vectors
 where each vector is the c(row, column) where the information is to be
 pulled from in the input files.

 This metadata is returned as the second list element of each
 blockcurve, e.g.:
 
  [[1]] [1] "data" #1 [2] "metadata"  [2][1] name #1
  
  [2][2] date-time #1
  
  [2][3] temp #1
  
  [[2]] [1] "data" #2 [2] "metadata"  [2][1] name #2
  
  [2][2] date-time #2
  
  [2][3] temp #2
  
  ...

 Calling \code{uninterleave} on the output of read_blocks works on block data
 and the associated metadata because uninterleave operates on the highest 
 level entries of the list (the [[1]] [[2]] level items), 
 leaving the meta-data associated with the block data

 \code{trans_block_to_wide} integrates this metadata into the
 wide-shaped dataframe it produces
}
