% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmPlotSubspaces.R
\name{dmPlotSubspaces}
\alias{dmPlotSubspaces}
\title{Create an image file for built subspaces}
\usage{
dmPlotSubspaces(
  level,
  enumeratedSubspaces,
  imageFileName,
  title,
  columnIndices,
  plotGenerativeDataParameters = dmPlotGenerativeDataParameters(percent = 10, colour =
    "red"),
  plotSubspaceParameters = dmPlotSubspaceParameters(percent = 100, colour = "green"),
  evaluateDataSourceFileName = "",
  plotEvaluateDataSourceParameters = NULL
)
}
\arguments{
\item{level}{Level for subspaces}

\item{enumeratedSubspaces}{Vector of enumerated subspaces}

\item{imageFileName}{Name of image file}

\item{title}{Title of image}

\item{columnIndices}{Vector of two column indices that are used for the two-dimensional projection.
Indices refer to indices of active columns of data source.}

\item{plotGenerativeDataParameters}{Plot generative data parameters, see dmPlotGenerativeDataParameters().}

\item{plotSubspaceParameters}{Plot parameters for subspaces, see dmPlotSubspaceParameters().}

\item{evaluateDataSourceFileName}{Name of evaluated data source file}

\item{plotEvaluateDataSourceParameters}{Plot parameters for evaluated data source, see dmPlotEvaluateDataSourceParameters().}
}
\value{
None
}
\description{
Create an image file containing two-dimensional projections of generative data, 
gernerative data assigned to subspaces and optionally an evaluated data source.
Plot parameters are passed by functions dmPlotGenerativeDataParameters(),
dmPlotSubspaceParameters(), dmPlotEvaluateDataSourceParameters().
Data points are drwan in the order generative data, generative data assigned to built subspaces
and evaluated data source.
}
\examples{
\dontrun{
dmRead("dm.bin", "gd.bin")
dmPlotSubspaces(0.73,
  c(1),
  "s1d34.png",
  "Subspace of Hierarchical, Categorical Data Model for the Iris Dataset",
  c(3, 4),
  dmPlotGenerativeDataParameters(10),
  dmPlotSubspaceParameters(100),
  "ds.bin",
  dmPlotEvaluateDataSourceParameters())}
}
