% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_species.R
\name{atlas_species}
\alias{atlas_species}
\title{Collect the set of species observed within the specified filters}
\usage{
atlas_species(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL
)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to
\code{\link[=galah_apply_profile]{galah_apply_profile()}}}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble),
returning matching species The \code{data.frame} object has attributes listing of
the user-supplied arguments of the \code{data_request}
(i.e., identify, filter, geolocate, columns)
}
\description{
While there are reasons why users may need to check every record meeting their
search criteria (i.e. using \code{\link[=atlas_occurrences]{atlas_occurrences()}}), a common use case
is to simply identify which species occur in a specified region, time period,
or taxonomic group. This function returns a \code{data.frame} with one row
per species, and columns giving associated taxonomic information.
}
\details{
The primary use case of this function is to extract species-level information
given a set of criteria defined by \code{\link[=search_taxa]{search_taxa()}},
\code{\link[=galah_filter]{galah_filter()}} or \code{\link[=galah_geolocate]{galah_geolocate()}}. If the purpose
is simply to get taxonomic information that is not restricted by filtering,
then \code{\link[=search_taxa]{search_taxa()}} is more efficient. Similarly, if counts are
required that include filter but without returning taxonomic detail, then
\code{\link[=atlas_counts]{atlas_counts()}} is more efficient (see examples).
}
\examples{
\dontrun{
# First register a valid email address
galah_config(email = "ala4r@ala.org.au")

# Get a list of species within genus "Heleioporus"
# (every row is a species with associated taxonomic data)
galah_call() |>
  galah_identify("Heleioporus") |>
  atlas_species()

# Get a list of species within family "Peramelidae"
galah_call() |>
  galah_identify("peramelidae") |>
  atlas_species()
  
# Or alternatively
request_data(type = "species") |>
  identify("peramelidae") |>
  collect()

# It's good idea to find how many species there are before downloading
galah_call() |>
  galah_identify("Heleioporus") |>
  atlas_counts(type = "species")
# Or alternatively
request_data(type = "species") |>
  identify("Heleioporus") |>
  count() |>
  collect()
}
}
