% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_all.R
\name{search_all}
\alias{search_all}
\alias{search_atlases}
\alias{search_reasons}
\alias{search_ranks}
\alias{search_fields}
\alias{search_assertions}
\alias{search_profiles}
\alias{search_providers}
\alias{search_collections}
\alias{search_datasets}
\alias{search_licences}
\alias{search_apis}
\alias{search_lists}
\title{Search for record information}
\usage{
search_all(type, query)

search_apis(query)

search_assertions(query)

search_atlases(query)

search_collections(query)

search_datasets(query)

search_providers(query)

search_fields(query)

search_licences(query)

search_reasons(query)

search_ranks(query)

search_profiles(query)

search_lists(query)
}
\arguments{
\item{type}{A string to specify what type of parameters should be searched.}

\item{query}{A string specifying a search term. Searches are not
case-sensitive.}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble)
containing all data that match the search query.
}
\description{
The living atlases store a huge amount of information, above and beyond the
occurrence records that are their main output. In \code{galah}, one way that
users can investigate this information is by searching for a specific option
or category for the type of information they are interested in.
Functions prefixed with \code{search_} do this, displaying any matches to a
search term within the valid options for the information specified by the
suffix.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{search_all()} is a helper function that can do searches within multiple
types of information from \code{search_} sub-functions.
See \code{Details} (below) for accepted values.
}
\details{
There are five categories of information, each with their own
specific sub-functions to look-up each type of information.
The available types of information for \code{search_all()} are:\tabular{llll}{
   \strong{Category} \tab \strong{Type} \tab \strong{Description} \tab \strong{Sub-functions} \cr
   configuration \tab \code{atlases} \tab Search for what atlases are available \tab \code{search_atlases()} \cr
    \tab \code{apis} \tab Search for what APIs & functions are available for each atlas \tab \code{search_apis()} \cr
    \tab \code{reasons} \tab Search for what values are acceptable as 'download reasons' for a specified atlas \tab \code{search_reasons()} \cr
   taxonomy \tab \code{taxa} \tab Search for one or more taxonomic names \tab \code{search_taxa()} \cr
    \tab \code{identifiers} \tab Take a universal identifier and return taxonomic information \tab \code{search_identifiers()} \cr
    \tab \code{ranks} \tab Search for valid taxonomic ranks (e.g. Kingdom, Class, Order, etc.) \tab \code{search_ranks()} \cr
   filters \tab \code{fields} \tab Search for fields that are stored in an atlas \tab \code{search_fields()} \cr
    \tab \code{assertions} \tab Search for results of data quality checks run by each atlas \tab \code{search_assertions()} \cr
    \tab \code{licenses} \tab Search for copyright licences applied to media \tab \code{search_licenses()} \cr
   group filters \tab \code{profiles} \tab Search for what data profiles are available \tab \code{search_profiles()} \cr
    \tab \code{lists} \tab Search for what species lists are available \tab \code{search_lists()} \cr
   data providers \tab \code{providers} \tab Search for which institutions have provided data \tab \code{search_providers()} \cr
    \tab \code{collections} \tab Search for the specific collections within those institutions \tab \code{search_collections()} \cr
    \tab \code{datasets} \tab Search for the data groupings within those collections \tab \code{search_datasets()} \cr
}
}
\section{Examples}{


Search for all fields that use include the word "date"

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_all(fields, "date")
}\if{html}{\out{</div>}}

Search for all fields that have information for "marine"

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_all(fields, "marine")
}\if{html}{\out{</div>}}

Search using a single term (See \code{\link[=search_taxa]{search_taxa()}} for more info)

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_taxa("Reptilia")
#> # A tibble: 1 x 9
#>   search_term scientific_name taxon_~1 rank  match~2 kingdom phylum class issues
#>   <chr>       <chr>           <chr>    <chr> <chr>   <chr>   <chr>  <chr> <chr> 
#> 1 Reptilia    REPTILIA        https:/~ class exactM~ Animal~ Chord~ Rept~ noIss~
#> # ... with abbreviated variable names 1: taxon_concept_id, 2: match_type
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_all(taxa, "Reptilia") # equivalent
}\if{html}{\out{</div>}}

Look up a unique taxon identifier (See \code{\link[=search_identifiers]{search_identifiers()}} for more info)

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_all(identifiers, 
           "https://id.biodiversity.org.au/node/apni/2914510") # equivalent
}\if{html}{\out{</div>}}

Search for species lists that match "endangered"

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_all(lists, "endangered") # equivalent
}\if{html}{\out{</div>}}

Search for a valid taxonomic rank, "subphylum"

\if{html}{\out{<div class="sourceCode r">}}\preformatted{search_all(ranks, "subphylum")
}\if{html}{\out{</div>}}
}

\references{
\itemize{
\item Darwin Core terms \url{https://dwc.tdwg.org/terms/}
\item ALA fields \url{https://api.ala.org.au/#ws72}
\item ALA assertions fields \url{https://api.ala.org.au/#ws81}
}
}
\seealso{
See \code{\link[=search_taxa]{search_taxa()}} and \code{\link[=search_identifiers]{search_identifiers()}} for more information
on taxonomic searches.
Use the \code{\link[=show_all]{show_all()}} function and \code{show_all_()} sub-functions to
show available options of information. These functions are used to pass valid
arguments to \code{\link[=galah_select]{galah_select()}}, \code{\link[=galah_filter]{galah_filter()}}, and related functions.
}
