% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models_grips.R
\name{coerce_models}
\alias{coerce_models}
\alias{as_emat2cq}
\alias{as_emat_complement}
\alias{as_emat2amat}
\alias{as_emat2elist}
\alias{as_elist2emat}
\alias{as_glist2emat}
\alias{as_glist2cq}
\alias{as_glist2graph}
\alias{as_glist2igraph}
\alias{as_emat2graph}
\alias{as_emat2igraph}
\alias{as_amat2emat}
\alias{as_emat2glist}
\alias{as_glist2out_edges}
\alias{as_K2amat}
\alias{as_K2graph}
\alias{as_sparse}
\title{Coerce models to different representations}
\usage{
as_emat2cq(emat, nvar = NULL)

as_emat_complement(emat, nvar)

as_emat2amat(emat, d)

as_emat2elist(emat)

as_elist2emat(elist)

as_glist2emat(glist)

as_glist2cq(glist)

as_glist2graph(glist, d)

as_glist2igraph(glist, d)

as_emat2graph(emat, d)

as_emat2igraph(emat, d)

as_amat2emat(amat, eps = 1e-04)

as_emat2glist(emat)

as_glist2out_edges(glist)

as_K2amat(K, eps = 1e-04)

as_K2graph(K)

as_sparse(K)
}
\arguments{
\item{emat}{Edge matrix (2 x p)}

\item{nvar}{Number of variables}

\item{d}{Number of columns in output.}

\item{elist}{Edge list (list of pairs)}

\item{glist}{Generator list}

\item{amat}{Adjacency matrix}

\item{eps}{Small number

glist <- list(c(1,2,3),c(2,3,4),c(5,6))
em <- as_glist2emat(glist)
am <- as_emat2amat(em, d=6)
ig <- as_emat2igraph(em)
el <- as_emat2elist(em)
igraph::max_cliques(ig)
as_emat2cq(em, 6)
as_emat_complement(em, 6)}

\item{K}{Concentration matrix}
}
\description{
Coerce models to different representations
}
