/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;

public abstract class SpecificConfig {
    protected static Log logger = LogFactory.getLog(SpecificConfig.class);
    private Configuration conf;

    public SpecificConfig(Configuration conf) {
        this.conf = conf;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected String getProperty(String prop) {
        return this.getConf().getProperty(prop);
    }

    protected String getProperty(String prop, String def) {
        return this.getConf().getProperty(prop, def);
    }

    protected void setProperty(String prop, String val) {
        this.getConf().setProperty(prop, val);
    }

    protected int getIntProperty(String prop, String def) {
        return Integer.parseInt(this.getConf().getProperty(prop, def));
    }

    protected double getDoubleProperty(String prop, String def) {
        return Double.parseDouble(this.getConf().getProperty(prop, def));
    }

    protected boolean getBoolProperty(String prop, String def) {
        return Boolean.parseBoolean(this.getConf().getProperty(prop, def));
    }

    protected void setIntProperty(String prop, int val) {
        this.setProperty(prop, "" + val);
    }

    protected void setDoubleProperty(String prop, double val) {
        this.setProperty(prop, "" + val);
    }

    protected void setBoolProperty(String prop, boolean val) {
        this.setProperty(prop, "" + val);
    }
}

