/*
 * Decompiled with CFR 0.152.
 */
package junit;

import junit.MyTestCase;
import org.af.jhlir.call.RCallServices;
import org.af.jhlir.call.RChar;
import org.af.jhlir.call.RInteger;
import org.af.jhlir.call.RList;
import org.af.jhlir.call.RMatrix;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RList_Test
extends MyTestCase {
    protected RList rList1;
    protected RList rList2;
    protected RList rList3;
    protected RList rList4;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getRServices().assign("rlist1", "list(xx=1:3, yy=list(), matrix(c(1,2,3,4),4,1), zz=\"foo\")");
        this.rList1 = this.getRServices().eval("rlist1").asRList();
        this.getRServices().assign("rlist2", "list(1:3, list(1,2,3), matrix(c(1,2,3,4),4,1), \"foo\")");
        this.rList2 = this.getRServices().eval("rlist2").asRList();
        this.getRServices().assign("rlist3", "list()");
        this.rList3 = this.getRServices().eval("rlist3").asRList();
        this.getRServices().assign("rlist4", "list(1:3, list(1,2,3), matrix(c(1,2,3,4),4,1), \"foo\")");
        this.getRServices().evalVoid("names(rlist4)<-c(\"A\",\"B\")");
        this.rList4 = this.getRServices().eval("rlist4").asRList();
    }

    @Test
    public void testAt() {
        Assert.assertEquals((long)this.rList1.getLength(), (long)4L);
        Assert.assertEquals((long)this.rList2.getLength(), (long)4L);
        Assert.assertEquals((long)this.rList3.getLength(), (long)0L);
        Assert.assertEquals((Object)this.rList1.getName(0), (Object)"xx");
        Assert.assertEquals((Object)this.rList1.getName(1), (Object)"yy");
        Assert.assertEquals((Object)this.rList1.getName(2), (Object)"");
        Assert.assertEquals((Object)this.rList1.getName(3), (Object)"zz");
        Assert.assertEquals((Object)this.rList1.getNames()[0], (Object)"xx");
        Assert.assertEquals((Object)this.rList1.getNames()[1], (Object)"yy");
        Assert.assertEquals((Object)this.rList1.getNames()[3], (Object)"zz");
        Assert.assertNull((Object)this.rList2.getNames());
        Assert.assertNull((Object)this.rList3.getNames());
        Assert.assertTrue((boolean)(this.rList1.get("xx") instanceof RInteger));
        Assert.assertTrue((boolean)(this.rList1.get("yy") instanceof RList));
        Assert.assertTrue((boolean)(this.rList1.get("zz") instanceof RChar));
        Assert.assertNull((Object)this.rList1.get("blah"));
        Assert.assertTrue((boolean)(this.rList1.get(0) instanceof RInteger));
        Assert.assertTrue((boolean)(this.rList1.get(1) instanceof RList));
        Assert.assertTrue((boolean)(this.rList1.get(2) instanceof RMatrix));
        Assert.assertTrue((boolean)(this.rList1.get(3) instanceof RChar));
        Assert.assertEquals((long)this.rList1.getNamesAsList().size(), (long)4L);
        Assert.assertEquals((Object)this.rList1.getNamesAsList().get(0), (Object)"xx");
        Assert.assertEquals((Object)this.rList4.getName(0), (Object)"A");
        Assert.assertEquals((Object)this.rList4.getName(1), (Object)"B");
        Assert.assertEquals((Object)this.rList4.getName(2), (Object)RCallServices.NA_CHAR);
        Assert.assertEquals((Object)this.rList4.getName(3), (Object)RCallServices.NA_CHAR);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerException1() {
        this.rList2.getName(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIndexOutOfBoundsException1() {
        this.rList1.get(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIndexOutOfBoundsException2() {
        this.rList1.get(4);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIndexOutOfBoundsException3() {
        this.rList3.get(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testIndexOutOfBoundsException4() {
        this.rList1.getName(9);
    }
}

