% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot2pfam.R
\name{uniprot2pfam}
\alias{uniprot2pfam}
\title{From UniProt ID to Pfam-A domain composition}
\usage{
uniprot2pfam(uniprot.id)
}
\arguments{
\item{uniprot.id}{UniProt ID}
}
\value{
a data frame with columns
\itemize{
\item \emph{uniprot} --- UniProt ID
\item \emph{length} --- protein length
\item \emph{hmm.acc} --- accession number of Pfam HMM model, e.g., PF08563
\item \emph{hmm.name} --- Pfam name, e.g., P53_TAD
\item \emph{start} --- Pfam domain start position
\item \emph{end} --- Pfam domain end position
\item \emph{type} --- Pfam type, including domain/motif/family
}
}
\description{
Map from UniProt ID to Pfam-A domain compostion.
}
\examples{
uniprot2pfam("Q5VWM5")  # PRAMEF9; PRAMEF15
uniprot2pfam("P04637")



}
