% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_w.R
\name{GetCloseMatches}
\alias{GetCloseMatches}
\title{Matches of character strings}
\usage{
GetCloseMatches(string = NULL, sequence_strings = NULL, n = 3L, cutoff = 0.6)
}
\arguments{
\item{string}{a character string.}

\item{sequence_strings}{a vector of character strings.}

\item{n}{an integer value specifying the maximum number of close matches to return; n must be greater than 0.}

\item{cutoff}{a float number in the range [0, 1], \emph{sequence_strings} that don't score at least that similar to \emph{string} are ignored.}
}
\description{
Matches of character strings
}
\details{
Returns a list of the best "good enough" matches. \emph{string} is a sequence for which close matches are desired (typically a string), and \emph{sequence_strings} is a list of sequences against
which to match \emph{string} (typically a list of strings).
}
\examples{

try({
  if (reticulate::py_available(initialize = FALSE)) {

    if (check_availability()) {

      library(fuzzywuzzyR)

      vec = c('Frodo Baggins', 'Tom Sawyer', 'Bilbo Baggin')

      str1 = 'Fra Bagg'

      GetCloseMatches(string = str1, sequence_strings = vec, n = 2L, cutoff = 0.6)

    }
  }
}, silent=TRUE)
}
\references{
https://www.npmjs.com/package/difflib, http://stackoverflow.com/questions/10383044/fuzzy-string-comparison
}
