% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_w.R
\docType{class}
\name{FuzzMatcher}
\alias{FuzzMatcher}
\title{Fuzzy character string matching ( ratios )}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
# init <- FuzzMatcher$new()
}
\arguments{
\item{string1}{a character string.}

\item{string2}{a character string.}

\item{force_ascii}{allow only ASCII characters (force convert to ascii)}

\item{full_process}{either TRUE or FALSE. If TRUE then it process the string by : 1. removing all but letters and numbers, 2. trim whitespace, 3. force to lower case}
}
\description{
Fuzzy character string matching ( ratios )
}
\details{
the \emph{Partial_token_set_ratio} method works in the following way : 1. Find all alphanumeric tokens in each string, 2. treat them as a set, 3. construct two strings of the form, <sorted_intersection><sorted_remainder>, 4. take ratios of those two strings, 5. controls for unordered partial matches (HERE partial match is TRUE)

the \emph{Partial_token_sort_ratio} method returns the ratio of the most similar substring as a number between 0 and 100 but sorting the token before comparing.

the \emph{Ratio} method returns a ration in form of an integer value based on a SequenceMatcher-like class, which is built on top of the Levenshtein package (https://github.com/miohtama/python-Levenshtein)

the \emph{QRATIO} method performs a quick ratio comparison between two strings. Runs full_process from utils on both strings. Short circuits if either of the strings is empty after processing.

the \emph{WRATIO} method returns a measure of the sequences' similarity between 0 and 100, using different algorithms. Steps in the order they occur :
1. Run full_process from utils on both strings, 2. Short circuit if this makes either string empty, 3. Take the ratio of the two processed strings (fuzz.ratio),
4. Run checks to compare the length of the strings (If one of the strings is more than 1.5 times as long as the other use partial_ratio comparisons - scale partial results by 0.9 - this makes sure only full results can return 100 -
If one of the strings is over 8 times as long as the other instead scale by 0.6), 5. Run the other ratio functions (if using partial ratio functions call partial_ratio,
partial_token_sort_ratio and partial_token_set_ratio scale all of these by the ratio based on length otherwise call token_sort_ratio and token_set_ratio all token based comparisons are scaled by 0.95 - on top of any partial scalars)
6. Take the highest value from these results round it and return it as an integer.

the \emph{UWRATIO} method returns a measure of the sequences' similarity between 0 and 100, using different algorithms. Same as WRatio but preserving unicode

the \emph{UQRATIO} method returns a Unicode quick ratio. It calls \emph{QRATIO} with force_ascii set to FALSE.

the \emph{Token_sort_ratio} method returns a measure of the sequences' similarity between 0 and 100 but sorting the token before comparing

the \emph{Partial_ratio} returns the ratio of the most similar substring as a number between 0 and 100.

the \emph{Token_set_ratio} method works in the following way : 1. Find all alphanumeric tokens in each string, 2. treat them as a set, 3. construct two strings of the form, <sorted_intersection><sorted_remainder>, 4. take ratios of those two strings, 5. controls for unordered partial matches (HERE partial match is FALSE)
}
\section{Methods}{


\describe{
 \item{\code{FuzzMatcher$new()}}{}

 \item{\code{--------------}}{}

 \item{\code{Partial_token_set_ratio(string1 = NULL, string2 = NULL, force_ascii = TRUE, full_process = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{Partial_token_sort_ratio(string1 = NULL, string2 = NULL, force_ascii = TRUE, full_process = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{Ratio(string1 = NULL, string2 = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{QRATIO(string1 = NULL, string2 = NULL, force_ascii = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{WRATIO(string1 = NULL, string2 = NULL, force_ascii = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{UWRATIO(string1 = NULL, string2 = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{UQRATIO(string1 = NULL, string2 = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Token_sort_ratio(string1 = NULL, string2 = NULL, force_ascii = TRUE, full_process = TRUE)}}{}

 \item{\code{--------------}}{}

 \item{\code{Partial_ratio(string1 = NULL, string2 = NULL)}}{}

 \item{\code{--------------}}{}

 \item{\code{Token_set_ratio(string1 = NULL, string2 = NULL, force_ascii = TRUE, full_process = TRUE)}}{}
 }
}

\examples{

if (check_availability()) {


  library(fuzzywuzzyR)

  s1 = "Atlanta Falcons"

  s2 = "New York Jets"

  init = FuzzMatcher$new()

  init$Partial_token_set_ratio(string1 = s1, string2 = s2, force_ascii = TRUE, full_process = TRUE)

  init$Partial_token_sort_ratio(string1 = s1, string2 = s2, force_ascii = TRUE, full_process = TRUE)

  init$Ratio(string1 = s1, string2 = s2)

  init$QRATIO(string1 = s1, string2 = s2, force_ascii = TRUE)

  init$WRATIO(string1 = s1, string2 = s2, force_ascii = TRUE)

  init$UWRATIO(string1 = s1, string2 = s2)

  init$UQRATIO(string1 = s1, string2 = s2)

  init$Token_sort_ratio(string1 = s1, string2 = s2, force_ascii = TRUE, full_process = TRUE)

  init$Partial_ratio(string1 = s1, string2 = s2)

  init$Token_set_ratio(string1 = s1, string2 = s2, force_ascii = TRUE, full_process = TRUE)


}
}
\references{
https://github.com/seatgeek/fuzzywuzzy/blob/master/fuzzywuzzy/fuzz.py
}
\keyword{datasets}
