% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regex_join.R
\name{regex_join}
\alias{regex_anti_join}
\alias{regex_full_join}
\alias{regex_inner_join}
\alias{regex_join}
\alias{regex_left_join}
\alias{regex_right_join}
\alias{regex_semi_join}
\title{Join two tables based on a regular expression in one column
matching the other}
\usage{
regex_join(x, y, by = NULL, mode = "inner")

regex_inner_join(x, y, by = NULL)

regex_left_join(x, y, by = NULL)

regex_right_join(x, y, by = NULL)

regex_full_join(x, y, by = NULL)

regex_semi_join(x, y, by = NULL)

regex_anti_join(x, y, by = NULL)
}
\arguments{
\item{x}{A tbl}

\item{y}{A tbl}

\item{by}{Columns by which to join the two tables}

\item{mode}{One of "inner", "left", "right", "full" "semi", or "anti"}
}
\description{
Join a table with a string column by a regular expression column
in another table
}
\examples{

library(dplyr)
library(ggplot2)
data(diamonds)

diamonds <- tbl_df(diamonds)

d <- data_frame(regex_name = c("^Idea", "mium", "Good"),
                type = 1:3)

# When they are inner_joined, only Good<->Good matches
diamonds \%>\%
  inner_join(d, by = c(cut = "regex_name"))

# but we can regex match them
diamonds \%>\%
 regex_inner_join(d, by = c(cut = "regex_name"))

}
\seealso{
\code{\link{str_detect}}
}

