% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protected_api-FutureResult-class.R
\name{FutureResult}
\alias{FutureResult}
\alias{as.character.FutureResult}
\alias{print.FutureResult}
\title{Results from resolving a future}
\usage{
FutureResult(
  value = NULL,
  visible = TRUE,
  stdout = NULL,
  conditions = NULL,
  rng = FALSE,
  ...,
  started = .POSIXct(NA_real_),
  finished = Sys.time(),
  version = "1.8"
)

\method{as.character}{FutureResult}(x, ...)

\method{print}{FutureResult}(x, ...)
}
\arguments{
\item{value}{The value of the future expression.
If the expression was not fully resolved (e.g. an error) occurred,
the the value is \code{NULL}.}

\item{visible}{If TRUE, the value was visible, otherwise invisible.}

\item{conditions}{A list of zero or more list elements each containing
a captured \link[base:conditions]{condition} and possibly more meta data such as the
call stack and a timestamp.}

\item{rng}{If TRUE, the \code{.Random.seed} was updated from resolving the
future, otherwise not.}

\item{started, finished}{\link[base:DateTimeClasses]{POSIXct} timestamps
when the evaluation of the future expression was started and finished.}

\item{version}{The version format of the results.}

\item{\ldots}{(optional) Additional named results to be returned.}
}
\value{
An object of class FutureResult.
}
\description{
Results from resolving a future
}
\details{
This function is only part of the \emph{backend} Future API.
This function is \emph{not} part of the frontend Future API.
}
\section{Note to developers}{

The FutureResult structure is \emph{under development} and may change at anytime,
e.g. elements may be renamed or removed.  Because of this, please avoid
accessing the elements directly in code.  Feel free to reach out if you need
to do so in your code.
}

\keyword{internal}
