% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableCores.R
\name{requestCore}
\alias{requestCore}
\title{Request a core for multicore processing}
\usage{
requestCore(await, maxTries = getOption("future::maxTries",
  trim(Sys.getenv("R_FUTURE_MAXTRIES", 1000))),
  delta = getOption("future::interval", 1), alpha = 1.01)
}
\arguments{
\item{await}{A function used to try to "collect"
finished multicore subprocesses.}

\item{maxTries}{Then maximum number of times subprocesses
should be collected before timeout.}

\item{delta}{Then base interval (in seconds) to wait
between each try.}

\item{alpha}{A multiplicative factor used to increase
the wait interval after each try.}
}
\value{
Invisible TRUE. If no cores are available after
        extensive waiting, then a timeout error is thrown.
}
\description{
If no cores are available, the current process
blocks until a core is available.
}
\keyword{internal}

