# WARNING - Generated by {fusen} from dev/flat_get_package_structure.Rmd: do not edit by hand # nolint: line_length_linter.

# Test full ----
dummypackage <- tempfile("drawpkg.structure")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(
  add_flat_template(pkg = dummypackage, overwrite = TRUE, open = FALSE)
)
flat_file <- dev_file[grepl("flat_", dev_file)]

usethis::with_project(dummypackage, {
  # Add an random R file with internal function
  dir.create("R")
  cat("extra_fun <- function() {1}\n", file = "R/my_extra_fun.R")

  test_that("get_package_structure allows classical package", {
    pkg_structure <- get_package_structure()

    expect_snapshot(pkg_structure)
    expect_snapshot(draw_package_structure(pkg_structure))
  })


  suppressMessages(
    inflate(
      pkg = dummypackage,
      flat_file = flat_file,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE
    )
  )

  test_that("get_package_structure allows fusen structure", {
    # Need to force edition to allow expect_snapshot
    # As we are in another directory using with_dir()
    local_edition(3)
    # Fix output conditions for this test for snapshots
    local_reproducible_output(
      width = 100,
      crayon = FALSE,
      unicode = FALSE,
      rstudio = FALSE,
      hyperlinks = FALSE,
      lang = "en",
      .env = parent.frame()
    )

    pkg_structure <- get_package_structure()

    expect_snapshot(pkg_structure)

    expect_snapshot(draw_package_structure(pkg_structure))
  })
})
