% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_flat_functions.R
\name{load_flat_functions}
\alias{load_flat_functions}
\title{Load the code of all 'function' chunk in a flat file}
\usage{
load_flat_functions(flat_file, envir = globalenv())
}
\arguments{
\item{flat_file}{Path to the flat to load functions from}

\item{envir}{the \code{\link[base]{environment}} in which \code{expr} is to
    be evaluated.  May also be \code{NULL}, a list, a data frame,
    a pairlist or an integer as specified to \code{\link[base]{sys.call}}.}
}
\value{
Path to flat file loaded.
Used for side effect: Load functions in the global environment.
}
\description{
Load the code of all 'function' chunk in a flat file
}
\examples{
\dontrun{
load_flat_functions(flat_file = "dev/flat_full.Rmd")
load_flat_functions(flat_file = "dev/flat_clean_fusen_files.Rmd")
}
}
