% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_matrix.R
\name{matrix_to_stack}
\alias{matrix_to_stack}
\alias{matrix_to_tidy}
\title{Matrix to stacked (= tidy) data.frame}
\usage{
matrix_to_stack(my_mat, value_col = "value",
  row_to_col = names(dimnames(my_mat))[1],
  col_to_col = names(dimnames(my_mat))[2])
}
\arguments{
\item{my_mat}{matrix you want to transform in stacked (= tidy) data.frame}

\item{value_col}{(optional) character vector to use for value column
(default: 'value')}

\item{row_to_col}{(optional) character vector used for name of column in
data.frame corresponding to rows in matrix (default: corresponding
dimension name)}

\item{col_to_col}{(optional) character vector used for name of column in
data.frame corresponding to columns in matrix (default: corresponding
dimension name)}
}
\value{
a stacked (= tidy) data.frame with, a column for row names, one for
column names and a third one for the values.
}
\description{
From a matrix with values to a stacked (= tidy) data.frame, exclude NA from
given data.frame.
}
\examples{
data("aravo", package = "ade4")

# Site-species matrix converted into data.frame
mat = as.matrix(aravo$spe)
dat = matrix_to_stack(mat, "value", "site", "species")
str(dat)

}
\seealso{
\code{\link[funrar]{stack_to_matrix}} for the reverse operation
}

