% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{ftest_plot}
\alias{ftest_plot}
\title{Plot the significance of different variables
 of a functional clustering}
\usage{
ftest_plot(fres, rtest,
           main     = "Title",
           opt.var  = c("components", "assemblages", "performances"),
           opt.crit = "Jaccard",
           opt.comp = NULL, opt.ass = NULL, opt.perf = NULL)
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained with the whole dataset using the function \code{\link{fclust}}.}

\item{rtest}{a list of matrices,
each containing the results for a clustering index.
\code{rtest} is an object generated by the function \code{ftest}.}

\item{main}{a string, that is used
as the first, reference part of the title of each graph.}

\item{opt.var}{a string, that indicates the variable to test.
The option can be \code{"components"}, \code{"assemblages"}
or \code{"performances"}.}

\item{opt.crit}{a list of strings,
indicating the clustering indices to plot.
The indices can be:
 "Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" or "Sokal_Sneath2".
 For more informations, see the notice of R-package \code{clusterCrit}.}

\item{opt.comp}{a list, that can include
\code{opt.comp} = \code{list("all.together", "fgroups.together",
"comps.together",
"fgroups.byfg", "comps.byfg", "sorted.tree", "sorted.leg", "all")}.
This option list manages the plot
of results obtained using the function \code{ftest}
with \code{opt.var = "components"}.
The item order in list is any.

\itemize{
 \item{\code{"all.together", "fgroups.together", "comps.together"}}
   {  plot \emph{(i)} the general mean index;
   \emph{(ii)} the mean indices for each functional group on a same plot;
   and \emph{(iii)} the mean index for each components
   on a same plot,
   when removing one after one each component from the dataset.
   This allows to evaluate the raw robustness of functional clustering
   to perturbation of dataset,
   and the weight of each cluster on functional clustering.
   }

\item{\code{"fgroups.byfg", "comps.byfg"}}{  plot
   \emph{(i)} mean component clusters,
   functional group by functional group;
   \emph{(ii)} a graph by component, functional group by functional group;
   This allows to evaluate the weight of each component
    on functional clustering.
   }

\item{\code{"sorted.tree", "sorted.leg"}}{  plot
  \emph{(i)} the hierarchical tree of components,
  with components decreasingly sorted according to their weight
  on functional clustering within each functional group;
  \emph{(ii)} the names of component decreasingly sorted
  according to their weight on functional clustering
  within each functional group.
  }

\item{\code{"all"}}{  plot all possible graphs.
  This option is equivalent to
  \code{opt.comp} = \code{list("all.together", "fgroups.together",
  "comps.together", "fgroups.byfg", "comps.byfg",
  "sorted.tree", "sorted.leg")}.
  }
}}

\item{opt.ass}{a list, that can include
\code{opt.ass} = \code{list("all.together", "motifs.together",
"assemblages.together",
"motifs.bymot", "assemblages.bymot", "sorted.leg", "all")}.
This option list manages the plot
of results obtained using the function \code{ftest}
with \code{opt.var = "assemblages"}.
The item order in list is any.

\itemize{
 \item{\code{"all.together", "motifs.together", "assemblages.together"}}
   {  plot \emph{(i)} the general mean index;
   \emph{(ii)} the mean indices for each assembly motif on a same plot;
   and \emph{(iii)} the mean index for each assemblages
   on a same plot,
   when removing one after one each assemblage from the dataset.
   This allows to evaluate the raw robustness of functional clustering
   to perturbation of dataset,
   and the weight of each assemblage on functional clustering.
   }

\item{\code{"motifs.bymot", "assemblages.bymot"}}{  plot
   \emph{(i)} mean assembly motifs,
   assembly motif by assembly motif;
   \emph{(ii)} a graph by removed assemblage,
   assembly motif by assembly motif;
   This allows to evaluate the weight of each assemblage
    on functional clustering.
   }

\item{\code{"sorted.leg"}}{  plot
  the names of assemblages decreasingly sorted
  according to their weight on functional clustering.
  }

\item{\code{"all"}}{  plot all possible graphs.
  This option is equivalent to
  \code{opt.ass} = \code{list("all.together", "motifs.together",
 "assemblages.together",
  "motifs.bymot", "assemblages.bymot", "sorted.leg")}.}
  }}

\item{opt.perf}{a list, that can include
a list, that can include
\code{opt.comp} = \code{list("all.together", "performances.together",
 "sorted.leg")}.
This option list manages the plot
of results obtained using the function \code{ftest}
with \code{opt.var = "performances"}.
The item order in list is any.

\itemize{
 \item{\code{"all.together", "performances.together"}}
   {  plot \emph{(i)} the general mean index;
   \emph{(ii)} the mean indices for each removed performance on a same plot,
   when removing one after one each performance from the dataset.
   This allows to evaluate the raw robustness of functional clustering
   to perturbation of dataset,
   and the weight of each performance on functional clustering.
   }

\item{\code{"sorted.leg"}}{  plot
  the names of performances decreasingly sorted
  according to their weight on functional clustering.
  }

\item{\code{"all"}}{  plot all possible graphs.
  This option is equivalent to
  \code{opt.comp} = \code{list("all.together", "performances.together",
 "sorted.leg")}.
  }
}}
}
\value{
Nothing. It is a procedure.
}
\description{
Different plots are built according to the tested variable.
}
\details{
The trees obtained by leaving out each element
are compared to the reference tree obtained
with all element of the variables
using different criteria of clustering:
"Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" and "Sokal_Sneath2" index.
 For more informations, see the notice of R-package \code{clusterCrit}.
}
\examples{

# Plot the hierachical tree of components
layout(matrix(c(1,2,3,4), nrow = 2, ncol = 2, byrow = TRUE))
fclust_plot(fres = CedarCreek.2004.2006.res, main  = "BioDIV2",
            opt.tree = "prd")

# Plot the significance of each component within each components cluster
ftest_plot(fres  = CedarCreek.2004.2006.res,
           rtest = CedarCreek.2004.2006.test.components,
           main  = "BioDIV2",
           opt.var = c("components"), opt.crit = "Jaccard")
layout(1)


}
\references{
Package "clusterCrit": Clustering Indices,
  by Bernard Desgraupes (University of Paris Ouest - Lab Modal'X)
}
