% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_fclust.R
\name{fboot_assemblages}
\alias{fboot_assemblages}
\title{Evaluate the robustness of a functional clustering
to perturbations of data}
\usage{
fboot_assemblages(fres,
                  opt.nbMax = fres$nbOpt, opt.R2 = FALSE, opt.plot = FALSE,
                  nbIter = 1, seed = NULL, rm.number = 0)
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained using the function \code{\link{fclust}}.}

\item{opt.nbMax}{a logical. If \code{opt.plot = TRUE},
the trees resulting from leaving out each performance is plotted.}

\item{opt.R2}{a logical. If \code{opt.R2 = TRUE},
the primary tree is validated
and the vectors of coefficient of determination (\code{R^2})
and efficiency (\code{E}) are computed.}

\item{opt.plot}{a logical. If \code{opt.plot = TRUE},
the primary trees resulting from leaving out each performance are plotted.
If \code{opt.R2 = TRUE},
the secondary trees resulting from leaving out each performance are plotted.}

\item{nbIter}{an integer, that indicates the number of random drawing to do.}

\item{seed}{an integer, that fixes a seed for random drawing.}

\item{rm.number}{an integer,
that indicates the number of elements to randomly remove.}
}
\value{
a list containing a matrix by clustering index.
}
\description{
Evaluate by bootstrapping
the robustness of a functional clustering
to perturbations of data. The perturbed data can be
the number of assemblages taken into account,
or the number of performances taken into account.
}
\details{
The trees obtained by bootstrapping of performances to omit
 are compared to the reference tree obtained with all components
 using different criteria :
 "Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" and "Sokal_Sneath2" index.
 For more informations, see the notice of R-package \code{clusterCrit}.
}
\references{
Package "clusterCrit": Clustering Indices,
  by Bernard Desgraupes (University of Paris Ouest - Lab Modal'X)
}
\keyword{internal}
