% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_operations.R
\name{spa_support}
\alias{spa_support}
\title{Get the support of a \code{pgeometry} object}
\usage{
spa_support(pgo)
}
\arguments{
\item{pgo}{A \code{pgeometry} object of any type.}
}
\value{
An \code{sfg} object that represents the support of \code{pgeometry}. It can be an empty object, if \code{pgeometry} is empty.
}
\description{
\code{spa_support()} yields a crisp spatial object (as an \code{sfg} object) that corresponds to the support of a \code{pgeometry} object given as input.
}
\details{
The \code{spa_support()} function employs the classical definition of \emph{support} from the fuzzy set theory in the context of Spatial Plateau Algebra.
The \emph{support} only comprises the points with membership degree greater than or equal to 1.
Hence, \code{spa_support()} returns the \code{sfg} object that represents the total extent of the \code{pgeometry} given as input.
If the \code{pgeometry} is empty, then an empty \code{sfg} object is returned.
}
\examples{
pcp1 <- create_component("POINT(0 0)", 0.3)
pcp2 <- create_component("MULTIPOINT((2 2), (2 4), (2 0))", 0.5)
pcp3 <- create_component("MULTIPOINT((1 1), (3 1), (1 3), (3 3))", 0.9)
pcp4 <- create_component("MULTIPOINT((1 2), (2 1), (3 2))", 1)
pcp5 <- create_component("MULTIPOINT((0 0.5), (2 3))", 0.7)
pcp6 <- create_component("MULTIPOINT((0 1), (3 3.5))", 0.85)
pcp7 <- create_component("MULTIPOINT((1 0), (4 2))", 0.4)

# Creating a plateau point object
ppoint <- create_pgeometry(list(pcp1, pcp2, pcp3, pcp4, pcp5), "PLATEAUPOINT")
ppoint

# Getting its support
spa_support(ppoint)

# Getting the support of an empty pgeometry
spa_support(create_empty_pgeometry("PLATEAUREGION"))
}
\references{
\href{https://onlinelibrary.wiley.com/doi/10.1111/tgis.13044}{Carniel, A. C.; Venâncio, P. V. A. B; Schneider, M. fsr: An R package for fuzzy spatial data handling. Transactions in GIS, vol. 27, no. 3, pp. 900-927, 2023.}

Underlying concepts and formal definitions of Spatial Plateau Algebra are introduced in:
\itemize{
\item \href{https://ieeexplore.ieee.org/document/8491565}{Carniel, A. C.; Schneider, M. Spatial Plateau Algebra: An Executable Type System for Fuzzy Spatial Data Types. In Proceedings of the 2018 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2018), pp. 1-8, 2018.}
}
}
